/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.errors;

import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;

public class ApiException
extends Exception {
    private int statusCode = 0;
    private HttpHeaders responseHeaders = null;
    private String responseData = null;

    public ApiException() {
    }

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int statusCode, HttpHeaders responseHeaders, String responseBody) {
        super(message, throwable);
        this.statusCode = statusCode;
        this.responseHeaders = responseHeaders;
        this.responseData = responseBody;
    }

    public ApiException(String message, int statusCode, HttpHeaders responseHeaders, String responseBody) {
        this(message, null, statusCode, responseHeaders, responseBody);
    }

    public ApiException(String message, Throwable throwable, int statusCode, HttpHeaders responseHeaders) {
        this(message, throwable, statusCode, responseHeaders, null);
    }

    public ApiException(int statusCode, HttpHeaders responseHeaders, String responseBody) {
        this(null, null, statusCode, responseHeaders, responseBody);
    }

    public ApiException(int statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    public ApiException(int statusCode, String message, HttpHeaders responseHeaders, String responseBody) {
        this(statusCode, message);
        this.responseHeaders = responseHeaders;
        this.responseData = responseBody;
    }

    public ApiException(String operationId, HttpResponse<String> response) {
        this(response.statusCode(), ApiException.formatExceptionMessage(operationId, response.statusCode(), response.body()), response.headers(), response.body());
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseData() {
        return this.responseData;
    }

    private static String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }
}

