/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.telemetry;

import dev.openfga.sdk.api.client.ApiResponse;
import dev.openfga.sdk.api.configuration.Configuration;
import dev.openfga.sdk.api.configuration.Credentials;
import dev.openfga.sdk.api.configuration.CredentialsMethod;
import dev.openfga.sdk.telemetry.Attribute;
import dev.openfga.sdk.telemetry.Metric;
import dev.openfga.sdk.util.StringUtil;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Attributes {
    public static final Attribute FGA_CLIENT_REQUEST_CLIENT_ID = new Attribute("fga-client.request.client_id");
    public static final Attribute FGA_CLIENT_REQUEST_METHOD = new Attribute("fga-client.request.method");
    public static final Attribute FGA_CLIENT_REQUEST_MODEL_ID = new Attribute("fga-client.request.model_id");
    public static final Attribute FGA_CLIENT_REQUEST_STORE_ID = new Attribute("fga-client.request.store_id");
    public static final Attribute FGA_CLIENT_REQUEST_BATCH_CHECK_SIZE = new Attribute("fga-client.request.batch_check_size");
    public static final Attribute FGA_CLIENT_RESPONSE_MODEL_ID = new Attribute("fga-client.response.model_id");
    public static final Attribute FGA_CLIENT_USER = new Attribute("fga-client.user");
    public static final Attribute HTTP_HOST = new Attribute("http.host");
    public static final Attribute HTTP_REQUEST_METHOD = new Attribute("http.request.method");
    public static final Attribute HTTP_REQUEST_RESEND_COUNT = new Attribute("http.request.resend_count");
    public static final Attribute HTTP_RESPONSE_STATUS_CODE = new Attribute("http.response.status_code");
    public static final Attribute URL_SCHEME = new Attribute("url.scheme");
    public static final Attribute URL_FULL = new Attribute("url.full");
    public static final Attribute USER_AGENT = new Attribute("user_agent.original");

    public static io.opentelemetry.api.common.Attributes prepare(Map<Attribute, String> attributes, Metric metric, Configuration configuration) {
        if (attributes == null || attributes.isEmpty() || configuration == null || configuration.getTelemetryConfiguration() == null || configuration.getTelemetryConfiguration().metrics() == null || configuration.getTelemetryConfiguration().metrics().isEmpty() || !configuration.getTelemetryConfiguration().metrics().containsKey(metric) || configuration.getTelemetryConfiguration().metrics().get(metric).isEmpty()) {
            return io.opentelemetry.api.common.Attributes.empty();
        }
        Map<Attribute, Optional<Object>> configAllowedAttributes = configuration.getTelemetryConfiguration().metrics().get(metric);
        AttributesBuilder builder = io.opentelemetry.api.common.Attributes.builder();
        for (Map.Entry<Attribute, Optional<Object>> configAllowedAttr : configAllowedAttributes.entrySet()) {
            String attrVal;
            Attribute attr = configAllowedAttr.getKey();
            if (!attributes.containsKey(attr) || StringUtil.isNullOrWhitespace(attrVal = attributes.getOrDefault(attr, ""))) continue;
            builder.put(AttributeKey.stringKey((String)attr.getName()), (Object)attrVal);
        }
        return builder.build();
    }

    public static Map<Attribute, String> fromHttpResponse(HttpResponse<?> response, Credentials credentials) {
        HashMap<Attribute, String> attributes = new HashMap<Attribute, String>();
        if (response != null) {
            attributes.put(HTTP_RESPONSE_STATUS_CODE, String.valueOf(response.statusCode()));
            String responseModelId = response.headers().firstValue("openfga-authorization-model-id").orElse(null);
            if (!StringUtil.isNullOrWhitespace(responseModelId)) {
                attributes.put(FGA_CLIENT_RESPONSE_MODEL_ID, responseModelId);
            }
        }
        if (credentials != null && credentials.getCredentialsMethod() == CredentialsMethod.CLIENT_CREDENTIALS && !StringUtil.isNullOrWhitespace(credentials.getClientCredentials().getClientId())) {
            attributes.put(FGA_CLIENT_REQUEST_CLIENT_ID, credentials.getClientCredentials().getClientId());
        }
        return attributes;
    }

    public static Map<Attribute, String> fromApiResponse(ApiResponse<?> response, Credentials credentials) {
        HashMap<Attribute, String> attributes = new HashMap<Attribute, String>();
        if (response != null) {
            String responseModelId;
            attributes.put(HTTP_RESPONSE_STATUS_CODE, String.valueOf(response.getStatusCode()));
            List responseModelIdList = response.getHeaders().getOrDefault("openfga-authorization-model-id", null);
            String string = responseModelId = responseModelIdList != null ? (String)responseModelIdList.get(0) : null;
            if (!StringUtil.isNullOrWhitespace(responseModelId)) {
                attributes.put(FGA_CLIENT_RESPONSE_MODEL_ID, responseModelId);
            }
        }
        if (credentials != null && credentials.getCredentialsMethod() == CredentialsMethod.CLIENT_CREDENTIALS && !StringUtil.isNullOrWhitespace(credentials.getClientCredentials().getClientId())) {
            attributes.put(FGA_CLIENT_REQUEST_CLIENT_ID, credentials.getClientCredentials().getClientId());
        }
        return attributes;
    }
}

