/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.telemetry;

import dev.openfga.sdk.api.configuration.Configuration;
import dev.openfga.sdk.api.configuration.TelemetryConfiguration;
import dev.openfga.sdk.telemetry.Attribute;
import dev.openfga.sdk.telemetry.Attributes;
import dev.openfga.sdk.telemetry.Counter;
import dev.openfga.sdk.telemetry.Counters;
import dev.openfga.sdk.telemetry.Histogram;
import dev.openfga.sdk.telemetry.Histograms;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.HashMap;
import java.util.Map;

public class Metrics {
    private final Meter meter = OpenTelemetry.noop().getMeterProvider().get("openfga-sdk");
    private final Map<String, LongCounter> counters = new HashMap<String, LongCounter>();
    private final Map<String, DoubleHistogram> histograms = new HashMap<String, DoubleHistogram>();
    private final Configuration configuration;

    public Metrics() {
        this.configuration = new Configuration();
        this.configuration.telemetryConfiguration(new TelemetryConfiguration());
    }

    public Metrics(Configuration configuration) {
        this.configuration = configuration;
        if (this.configuration.getTelemetryConfiguration() == null) {
            this.configuration.telemetryConfiguration(new TelemetryConfiguration());
        }
    }

    public Meter getMeter() {
        return this.meter;
    }

    public LongCounter getCounter(Counter counter, Long value, Map<Attribute, String> attributes) {
        if (this.configuration.getTelemetryConfiguration().metrics() == null || !this.configuration.getTelemetryConfiguration().metrics().containsKey(counter)) {
            return null;
        }
        if (!this.counters.containsKey(counter.getName())) {
            this.counters.put(counter.getName(), this.meter.counterBuilder(counter.getName()).setDescription(counter.getDescription()).build());
        }
        LongCounter counterInstance = this.counters.get(counter.getName());
        if (value != null) {
            counterInstance.add(value.longValue(), Attributes.prepare(attributes, counter, this.configuration));
        }
        return counterInstance;
    }

    public DoubleHistogram getHistogram(Histogram histogram, Double value, Map<Attribute, String> attributes) {
        if (this.configuration.getTelemetryConfiguration().metrics() == null || !this.configuration.getTelemetryConfiguration().metrics().containsKey(histogram)) {
            return null;
        }
        if (!this.histograms.containsKey(histogram.getName())) {
            this.histograms.put(histogram.getName(), this.meter.histogramBuilder(histogram.getName()).setDescription(histogram.getDescription()).setUnit(histogram.getUnit()).build());
        }
        DoubleHistogram histogramInstance = this.histograms.get(histogram.getName());
        if (value != null) {
            histogramInstance.record(value.doubleValue(), Attributes.prepare(attributes, histogram, this.configuration));
        }
        return histogramInstance;
    }

    public LongCounter credentialsRequest(Long value, Map<Attribute, String> attributes) {
        return this.getCounter(Counters.CREDENTIALS_REQUEST, value, attributes);
    }

    public DoubleHistogram requestDuration(Double value, Map<Attribute, String> attributes) {
        return this.getHistogram(Histograms.REQUEST_DURATION, value, attributes);
    }

    public DoubleHistogram queryDuration(Double value, Map<Attribute, String> attributes) {
        return this.getHistogram(Histograms.QUERY_DURATION, value, attributes);
    }
}

