/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.autoconfigure;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.openfga.OpenFga;
import dev.openfga.autoconfigure.ConditionalOnFgaProperties;
import dev.openfga.autoconfigure.HttpClientBuilderCustomizer;
import dev.openfga.autoconfigure.OpenFgaProperties;
import dev.openfga.autoconfigure.TelemetryAttribute;
import dev.openfga.autoconfigure.TelemetryMetric;
import dev.openfga.sdk.api.client.ApiClient;
import dev.openfga.sdk.api.client.OpenFgaClient;
import dev.openfga.sdk.api.configuration.ApiToken;
import dev.openfga.sdk.api.configuration.ClientConfiguration;
import dev.openfga.sdk.api.configuration.ClientCredentials;
import dev.openfga.sdk.api.configuration.Credentials;
import dev.openfga.sdk.api.configuration.CredentialsMethod;
import dev.openfga.sdk.api.configuration.TelemetryConfiguration;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnFgaProperties
@EnableConfigurationProperties(value={OpenFgaProperties.class})
public class OpenFgaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ClientConfiguration fgaConfig(OpenFgaProperties openFgaProperties) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        PropertyMapper map = PropertyMapper.get();
        map.from(openFgaProperties::getCredentials).whenNonNull().as(OpenFgaAutoConfiguration::toCredentials).to(arg_0 -> ((ClientConfiguration)clientConfiguration).credentials(arg_0));
        map.from(openFgaProperties::getApiUrl).whenHasText().to(arg_0 -> ((ClientConfiguration)clientConfiguration).apiUrl(arg_0));
        map.from(openFgaProperties::getStoreId).whenHasText().to(arg_0 -> ((ClientConfiguration)clientConfiguration).storeId(arg_0));
        map.from(openFgaProperties::getAuthorizationModelId).whenHasText().to(arg_0 -> ((ClientConfiguration)clientConfiguration).authorizationModelId(arg_0));
        map.from(openFgaProperties::getUserAgent).whenHasText().to(arg_0 -> ((ClientConfiguration)clientConfiguration).userAgent(arg_0));
        map.from(openFgaProperties::getReadTimeout).whenNonNull().to(arg_0 -> ((ClientConfiguration)clientConfiguration).readTimeout(arg_0));
        map.from(openFgaProperties::getConnectTimeout).whenNonNull().to(arg_0 -> ((ClientConfiguration)clientConfiguration).connectTimeout(arg_0));
        map.from(openFgaProperties::getMaxRetries).whenNonNull().to(arg_0 -> ((ClientConfiguration)clientConfiguration).maxRetries(arg_0));
        map.from(openFgaProperties::getMinimumRetryDelay).whenNonNull().to(arg_0 -> ((ClientConfiguration)clientConfiguration).minimumRetryDelay(arg_0));
        map.from(openFgaProperties::getDefaultHeaders).whenNonNull().to(arg_0 -> ((ClientConfiguration)clientConfiguration).defaultHeaders(arg_0));
        map.from(openFgaProperties::getTelemetryConfiguration).whenNonNull().as(OpenFgaAutoConfiguration::toTelemetryConfiguration).to(arg_0 -> ((ClientConfiguration)clientConfiguration).telemetryConfiguration(arg_0));
        return clientConfiguration;
    }

    private static Credentials toCredentials(OpenFgaProperties.Credentials credentialsProperties) {
        Credentials credentials = new Credentials();
        if (OpenFgaProperties.CredentialsMethod.API_TOKEN == credentialsProperties.getMethod()) {
            credentials.setCredentialsMethod(CredentialsMethod.API_TOKEN);
            credentials.setApiToken(new ApiToken(credentialsProperties.getConfig().getApiToken()));
        } else if (OpenFgaProperties.CredentialsMethod.CLIENT_CREDENTIALS == credentialsProperties.getMethod()) {
            ClientCredentials clientCredentials = new ClientCredentials().clientId(credentialsProperties.getConfig().getClientId()).clientSecret(credentialsProperties.getConfig().getClientSecret()).apiTokenIssuer(credentialsProperties.getConfig().getApiTokenIssuer()).apiAudience(credentialsProperties.getConfig().getApiAudience()).scopes(credentialsProperties.getConfig().getScopes());
            credentials.setCredentialsMethod(CredentialsMethod.CLIENT_CREDENTIALS);
            credentials.setClientCredentials(clientCredentials);
        }
        return credentials;
    }

    private static TelemetryConfiguration toTelemetryConfiguration(Map<TelemetryMetric, Map<TelemetryAttribute, Object>> telemetryConfiguration) {
        return new TelemetryConfiguration().metrics(telemetryConfiguration.entrySet().stream().collect(Collectors.toMap(e -> ((TelemetryMetric)((Object)((Object)e.getKey()))).getMetric(), metric -> ((Map)metric.getValue()).entrySet().stream().collect(Collectors.toMap(metricConfig -> ((TelemetryAttribute)((Object)((Object)((Object)metricConfig.getKey())))).getAttribute(), metricConfig -> Optional.ofNullable(metricConfig.getValue()))))));
    }

    @Bean
    @ConditionalOnProperty(name={"openfga.http-version"})
    @ConditionalOnMissingBean
    HttpClient.Builder defaultHttpClientBuilder() {
        return HttpClient.newBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    HttpClientBuilderCustomizer defaultHttpClientBuilderCustomizer(OpenFgaProperties openFgaProperties) {
        return builder -> {
            if (openFgaProperties.getHttpVersion() != null) {
                builder.version(openFgaProperties.getHttpVersion().getVersion());
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiClient apiClient(ObjectProvider<HttpClient.Builder> httpClientBuilderProvider, ObjectProvider<ObjectMapper> objectMapperProvider, HttpClientBuilderCustomizer httpClientBuilderCustomizer) {
        if (httpClientBuilderProvider.getIfAvailable() == null && objectMapperProvider.getIfAvailable() == null) {
            return new ApiClient();
        }
        HttpClient.Builder httpClientBuilder = (HttpClient.Builder)httpClientBuilderProvider.getIfAvailable(HttpClient::newBuilder);
        httpClientBuilderCustomizer.customize(httpClientBuilder);
        return new ApiClient(httpClientBuilder, (ObjectMapper)objectMapperProvider.getIfAvailable(OpenFgaAutoConfiguration::createDefaultObjectMapper));
    }

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new JsonNullableModule());
        return mapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenFgaClient fgaClient(ClientConfiguration configuration, ApiClient apiClient) {
        try {
            return new OpenFgaClient(configuration, apiClient);
        }
        catch (FgaInvalidParameterException e) {
            throw new BeanCreationException("Failed to create OpenFgaClient", (Throwable)e);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenFga fga(OpenFgaClient openFgaClient) {
        return new OpenFga(openFgaClient);
    }
}

