/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.autoconfigure;

import dev.openfga.autoconfigure.HttpVersion;
import dev.openfga.autoconfigure.TelemetryAttribute;
import dev.openfga.autoconfigure.TelemetryMetric;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="openfga")
public class OpenFgaProperties
implements InitializingBean {
    private String apiUrl;
    private String storeId;
    private String authorizationModelId;
    private Credentials credentials;
    private String userAgent;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration readTimeout;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration connectTimeout;
    private Integer maxRetries;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration minimumRetryDelay;
    private HttpVersion httpVersion;
    private Map<String, String> defaultHeaders;
    private Map<TelemetryMetric, Map<TelemetryAttribute, Object>> telemetryConfiguration;

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    public void setAuthorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Duration getMinimumRetryDelay() {
        return this.minimumRetryDelay;
    }

    public void setMinimumRetryDelay(Duration minimumRetryDelay) {
        this.minimumRetryDelay = minimumRetryDelay;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public Map<TelemetryMetric, Map<TelemetryAttribute, Object>> getTelemetryConfiguration() {
        return this.telemetryConfiguration;
    }

    public void setTelemetryConfiguration(Map<TelemetryMetric, Map<TelemetryAttribute, Object>> telemetryConfiguration) {
        this.telemetryConfiguration = telemetryConfiguration;
    }

    public void afterPropertiesSet() {
        this.validate();
    }

    public void validate() {
        Credentials credentialsProperty = this.credentials;
        if (credentialsProperty != null) {
            CredentialsMethod credentialsMethod = this.credentials.getMethod();
            if (credentialsMethod == null) {
                throw new IllegalStateException("credentials method must not be null");
            }
            CredentialsConfiguration credentialsConfig = credentialsProperty.getConfig();
            if (credentialsMethod == CredentialsMethod.API_TOKEN) {
                if (credentialsConfig == null || !StringUtils.hasText((String)credentialsConfig.getApiToken())) {
                    throw new IllegalStateException("'API_TOKEN' credentials method specified, but no token specified");
                }
            } else if (credentialsMethod == CredentialsMethod.CLIENT_CREDENTIALS) {
                if (!(credentialsConfig != null && StringUtils.hasText((String)credentialsConfig.getApiTokenIssuer()) && StringUtils.hasText((String)credentialsConfig.getClientId()) && StringUtils.hasText((String)credentialsConfig.getClientSecret()))) {
                    throw new IllegalStateException("'CLIENT_CREDENTIALS' configuration must contain 'client-id', 'client-secret', and 'api-token-issuer'");
                }
            } else if (credentialsMethod != CredentialsMethod.NONE) {
                throw new IllegalStateException("credentials method must be either 'NONE', 'API_TOKEN', or 'CLIENT_CREDENTIALS'");
            }
        }
        OpenFgaProperties.assertPositivity(this.readTimeout, "readTimeout");
        OpenFgaProperties.assertPositivity(this.connectTimeout, "connectTimeout");
        OpenFgaProperties.assertPositivity(this.minimumRetryDelay, "minimumRetryDelay");
        if (this.maxRetries != null) {
            if (this.maxRetries < 0) {
                throw new IllegalStateException("maxRetries must be positive or zero");
            }
            if (this.minimumRetryDelay == null) {
                throw new IllegalStateException("minimumRetryDelay must be set if maxRetries is set");
            }
        }
    }

    private static void assertPositivity(Duration duration, String fieldName) {
        if (duration != null && duration.isNegative()) {
            throw new IllegalStateException("%s must be positive".formatted(fieldName));
        }
    }

    public static class Credentials {
        private CredentialsMethod method;
        private CredentialsConfiguration config;

        public CredentialsMethod getMethod() {
            return this.method;
        }

        public void setMethod(CredentialsMethod method) {
            this.method = method;
        }

        public CredentialsConfiguration getConfig() {
            return this.config;
        }

        public void setConfig(CredentialsConfiguration config) {
            this.config = config;
        }
    }

    public static enum CredentialsMethod {
        NONE,
        API_TOKEN,
        CLIENT_CREDENTIALS;

    }

    public static class CredentialsConfiguration {
        private String apiToken;
        private String apiTokenIssuer;
        private String apiAudience;
        private String clientId;
        private String clientSecret;
        private String scopes;

        public String getApiTokenIssuer() {
            return this.apiTokenIssuer;
        }

        public void setApiTokenIssuer(String apiTokenIssuer) {
            this.apiTokenIssuer = apiTokenIssuer;
        }

        public String getApiAudience() {
            return this.apiAudience;
        }

        public void setApiAudience(String apiAudience) {
            this.apiAudience = apiAudience;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getApiToken() {
            return this.apiToken;
        }

        public void setApiToken(String apiToken) {
            this.apiToken = apiToken;
        }

        public String getScopes() {
            return this.scopes;
        }

        public void setScopes(String scopes) {
            this.scopes = scopes;
        }
    }
}

