package monocle.law.discipline

import monocle.Lens
import monocle.law.LensLaws
import org.scalacheck.Arbitrary
import org.scalacheck.Prop._
import org.typelevel.discipline.Laws

import cats.Eq

object LensTests extends Laws {
  def apply[S: Arbitrary: Eq, A: Arbitrary: Eq](lens: Lens[S, A])(implicit arbAA: Arbitrary[A => A]): RuleSet =
    apply[S, A, Unit](_ => lens)

  def apply[S: Arbitrary: Eq, A: Arbitrary: Eq, I: Arbitrary](
    f: I => Lens[S, A]
  )(implicit arbAA: Arbitrary[A => A]): RuleSet = {
    def laws(i: I) = LensLaws(f(i))
    new SimpleRuleSet(
      "Lens",
      "replace what you get"            -> forAll((s: S, i: I) => laws(i).getReplace(s)),
      "get what you replace"            -> forAll((s: S, a: A, i: I) => laws(i).replaceGet(s, a)),
      "replace idempotent"              -> forAll((s: S, a: A, i: I) => laws(i).replaceIdempotent(s, a)),
      "modify id = id"                  -> forAll((s: S, i: I) => laws(i).modifyIdentity(s)),
      "compose modify"                  -> forAll((s: S, g: A => A, h: A => A, i: I) => laws(i).composeModify(s, g, h)),
      "consistent replace with modify"  -> forAll((s: S, a: A, i: I) => laws(i).consistentReplaceModify(s, a)),
      "consistent modify with modifyId" -> forAll((s: S, g: A => A, i: I) => laws(i).consistentModifyModifyId(s, g)),
      "consistent get with modifyId"    -> forAll((s: S, i: I) => laws(i).consistentGetModifyId(s))
    )
  }
}
