/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.AbstractIdentity;
import dev.orne.beans.IdentityTokenFormatter;
import dev.orne.beans.UnrecognizedIdentityTokenException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="0.5")
public abstract class AbstractComposedIdentity
extends AbstractIdentity {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_SEPARATOR = ",";
    public static final String DEFAULT_NULL_PLACEHOLDER = "\u0000";

    protected AbstractComposedIdentity() {
    }

    @Override
    protected String getIdentityTokenBody() {
        Object[] parts = this.getIdentityTokenBodyParts();
        if (parts.length == 0) {
            return null;
        }
        String placeholder = this.getIdentityTokenBodyPartsNullPlaceholder();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] != null) continue;
            parts[i] = placeholder;
        }
        return StringUtils.join((Object[])parts, (String)this.getIdentityTokenBodyPartsSeparator());
    }

    @NotNull
    protected abstract String[] getIdentityTokenBodyParts();

    @NotNull
    protected String getIdentityTokenBodyPartsSeparator() {
        return DEFAULT_SEPARATOR;
    }

    @NotNull
    protected String getIdentityTokenBodyPartsNullPlaceholder() {
        return DEFAULT_NULL_PLACEHOLDER;
    }

    @NotNull
    public static String[] extractTokenBodyParts(@NotNull String prefix, @NotNull String token) {
        return AbstractComposedIdentity.extractTokenBodyParts(prefix, token, DEFAULT_SEPARATOR, DEFAULT_NULL_PLACEHOLDER);
    }

    @NotNull
    public static String[] extractTokenBodyParts(@NotNull String prefix, @NotNull String token, @NotNull String separator) {
        return AbstractComposedIdentity.extractTokenBodyParts(prefix, token, separator, DEFAULT_NULL_PLACEHOLDER);
    }

    @NotNull
    public static String[] extractTokenBodyParts(@NotNull String prefix, @NotNull String token, @NotNull String separator, @NotNull String placeholder) {
        String[] result;
        Validate.notNull((Object)prefix);
        Validate.notNull((Object)token);
        Validate.notNull((Object)separator);
        Validate.notNull((Object)placeholder);
        String body = IdentityTokenFormatter.parse(prefix, token);
        if (body == null) {
            result = new String[]{};
        } else {
            result = body.split(separator);
            for (int i = 0; i < result.length; ++i) {
                if (!placeholder.equals(result[i])) continue;
                result[i] = null;
            }
        }
        return result;
    }

    @NotNull
    public static String[] extractRequiredTokenBodyParts(@NotNull String prefix, @NotNull String token, int expectedParts) {
        return AbstractComposedIdentity.extractRequiredTokenBodyParts(prefix, token, DEFAULT_SEPARATOR, DEFAULT_NULL_PLACEHOLDER, expectedParts);
    }

    @NotNull
    public static String[] extractRequiredTokenBodyParts(@NotNull String prefix, @NotNull String token, @NotNull String separator, int expectedParts) {
        return AbstractComposedIdentity.extractRequiredTokenBodyParts(prefix, token, separator, DEFAULT_NULL_PLACEHOLDER, expectedParts);
    }

    @NotNull
    public static String[] extractRequiredTokenBodyParts(@NotNull String prefix, @NotNull String token, @NotNull String separator, @NotNull String placeholder, int expectedParts) {
        String[] result = AbstractComposedIdentity.extractTokenBodyParts(prefix, token, separator, placeholder);
        AbstractComposedIdentity.validateTokenBodyParts(token, result, expectedParts);
        return result;
    }

    private static void validateTokenBodyParts(@NotNull String token, @NotNull String[] parts, int expectedParts) {
        if (parts.length != expectedParts) {
            throw new UnrecognizedIdentityTokenException("Unrecognized identity token: " + token);
        }
    }
}

