/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.Identity;
import dev.orne.beans.IdentityTokenFormatter;
import dev.orne.beans.UnrecognizedIdentityTokenException;
import dev.orne.beans.ValidIdentityToken;
import dev.orne.beans.ValidIdentityTokenPrefix;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public abstract class AbstractIdentity
implements Identity {
    private static final long serialVersionUID = 1L;
    private transient String identityToken;

    protected AbstractIdentity() {
    }

    @NotNull
    @ValidIdentityTokenPrefix
    protected String getIdentityTokenPrefix() {
        return "";
    }

    protected abstract String getIdentityTokenBody();

    protected final String parseIdentityTokenBody(@NotNull String token) throws UnrecognizedIdentityTokenException {
        return IdentityTokenFormatter.parse(this.getIdentityTokenPrefix(), token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @ValidIdentityToken
    public String getIdentityToken() {
        AbstractIdentity abstractIdentity = this;
        synchronized (abstractIdentity) {
            if (this.identityToken == null) {
                this.identityToken = IdentityTokenFormatter.format(this.getIdentityTokenPrefix(), this.getIdentityTokenBody());
            }
            return this.identityToken;
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getClass()).build();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return obj.getClass() == this.getClass();
    }

    public String toString() {
        return this.getIdentityToken();
    }
}

