/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL, since="0.1")
public class BeanAnnotationFinder<T extends Annotation, L extends Annotation> {
    private static final Logger LOG = LoggerFactory.getLogger(BeanAnnotationFinder.class);
    private static final Cache SHARED_CACHE = new WeakHashMapCache();
    @NotNull
    private final Class<T> annotationType;
    private final Class<L> annotationListType;
    private final AnnotationListExtractor<L, T> extractor;
    @NotNull
    private Cache cache = SHARED_CACHE;

    public BeanAnnotationFinder(@NotNull Class<T> annotationType) {
        this(annotationType, null, null);
    }

    public BeanAnnotationFinder(@NotNull Class<T> annotationType, Class<L> annotationListType, AnnotationListExtractor<L, T> extractor) {
        Validate.notNull(annotationType, (String)"Annotation type is required.", (Object[])new Object[0]);
        this.annotationType = annotationType;
        if (annotationListType == null != (extractor == null)) {
            LOG.warn("To support annotation lists both 'annotationListType' and 'extractor' are required. Annotation list support is disabled. Passed values are: '{}' and '{}'", annotationListType, extractor);
        }
        this.annotationListType = annotationListType;
        this.extractor = extractor;
    }

    @NotNull
    public Class<T> getAnnotationType() {
        return this.annotationType;
    }

    public Class<L> getAnnotationListType() {
        return this.annotationListType;
    }

    public AnnotationListExtractor<L, T> getExtractor() {
        return this.extractor;
    }

    @NotNull
    protected Cache getCache() {
        return this.cache;
    }

    protected BeanAnnotationFinder<T, L> setCache(Cache cache) {
        this.cache = cache == null ? SHARED_CACHE : cache;
        return this;
    }

    @NotNull
    public Set<T> find(@NotNull Class<?> type) {
        Validate.notNull(type, (String)"Type is required.", (Object[])new Object[0]);
        return this.findAnnotations(type, new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Set<T> findAnnotations(@NotNull Class<?> type, @NotNull Set<Class<?>> visitedTypes) {
        HashSet<T> annotations = new HashSet<T>(0);
        if (!visitedTypes.contains(type)) {
            Cache cache = this.cache;
            synchronized (cache) {
                CacheEntryKey<T> cacheKey = new CacheEntryKey<T>(type, this.annotationType);
                Set<T> cachedDefinitions = this.cache.get(cacheKey);
                if (cachedDefinitions == null) {
                    Set<T> foundAnnotatios = this.findAllAnnotations(type);
                    annotations.addAll(foundAnnotatios);
                    LOG.debug("Caching annotations for type {}: {}", type, annotations);
                    this.cache.put(cacheKey, foundAnnotatios);
                } else {
                    annotations.addAll(cachedDefinitions);
                }
            }
            visitedTypes.add(type);
        }
        return annotations;
    }

    @NotNull
    protected Set<T> findAllAnnotations(@NotNull Class<?> type) {
        HashSet annotations = new HashSet(0);
        HashSet visitedTypes = new HashSet();
        visitedTypes.add(type);
        this.addDirectAnnotation(type, annotations);
        this.addDirectAnnotationsList(type, annotations);
        this.addInterfacesAnnotations(type, annotations, visitedTypes);
        this.addSuperclassAnnotations(type, annotations, visitedTypes);
        return annotations;
    }

    protected void addDirectAnnotation(@NotNull Class<?> type, @NotNull Set<T> annotations) {
        T annotation = type.getAnnotation(this.annotationType);
        if (annotation != null) {
            annotations.add(annotation);
        }
    }

    protected void addDirectAnnotationsList(@NotNull Class<?> type, @NotNull Set<T> annotations) {
        L annotationsList;
        if (this.annotationListType != null && this.extractor != null && (annotationsList = type.getAnnotation(this.annotationListType)) != null) {
            annotations.addAll(Arrays.asList(this.extractor.extract((Annotation)annotationsList)));
        }
    }

    protected void addSuperclassAnnotations(@NotNull Class<?> type, @NotNull Set<T> annotations, @NotNull Set<Class<?>> visitedTypes) {
        if (type.getSuperclass() != null) {
            annotations.addAll(this.findAnnotations(type.getSuperclass(), visitedTypes));
        }
    }

    protected void addInterfacesAnnotations(@NotNull Class<?> type, @NotNull Set<T> annotations, @NotNull Set<Class<?>> visitedTypes) {
        for (Class<?> iface : type.getInterfaces()) {
            annotations.addAll(this.findAnnotations(iface, visitedTypes));
        }
    }

    @API(status=API.Status.INTERNAL, since="0.1")
    @FunctionalInterface
    public static interface AnnotationListExtractor<L extends Annotation, T extends Annotation> {
        @NotNull
        public T[] extract(L var1);
    }

    @API(status=API.Status.INTERNAL, since="0.1")
    protected static interface Cache {
        public boolean contains(@NotNull CacheEntryKey<?> var1);

        public <T extends Annotation> Set<T> get(@NotNull CacheEntryKey<T> var1);

        public <T extends Annotation> void put(@NotNull CacheEntryKey<T> var1, @NotNull Set<T> var2);
    }

    @API(status=API.Status.INTERNAL, since="0.1")
    protected static final class CacheEntryKey<T extends Annotation> {
        @NotNull
        private final Class<?> type;
        @NotNull
        private final Class<T> annotationType;

        public CacheEntryKey(@NotNull Class<?> type, @NotNull Class<T> annotationType) {
            this.type = type;
            this.annotationType = annotationType;
        }

        @NotNull
        public Class<?> getType() {
            return this.type;
        }

        @NotNull
        public Class<T> getAnnotationType() {
            return this.annotationType;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.getClass()).append(this.type).append(this.annotationType).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            CacheEntryKey other = (CacheEntryKey)obj;
            return new EqualsBuilder().append(this.type, other.type).append(this.annotationType, other.annotationType).isEquals();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("type", this.type).append("annotationType", this.annotationType).toString();
        }
    }

    @API(status=API.Status.INTERNAL, since="0.1")
    protected static class WeakHashMapCache
    implements Cache {
        private final WeakHashMap<CacheEntryKey<?>, Set<? extends Annotation>> entries = new WeakHashMap();

        @Override
        public synchronized boolean contains(@NotNull CacheEntryKey<?> key) {
            return this.entries.containsKey(key);
        }

        @Override
        @NotNull
        public synchronized <T extends Annotation> void put(@NotNull CacheEntryKey<T> key, @NotNull Set<T> value) {
            this.entries.put(key, value);
        }

        @Override
        public synchronized <T extends Annotation> Set<T> get(@NotNull CacheEntryKey<T> key) {
            return this.entries.get(key);
        }
    }
}

