/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.ValidBeanIdentity;
import dev.orne.beans.ValidBeanReference;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public final class BeanValidationUtils {
    @NotNull
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    private BeanValidationUtils() {
    }

    public static Validator getValidator() {
        return validator;
    }

    public static void setValidator(@NotNull Validator validator) {
        Validate.notNull((Object)validator, (String)"Validator is required.", (Object[])new Object[0]);
        BeanValidationUtils.validator = validator;
    }

    public static boolean isValid(@NotNull Object obj, Class<?> ... groups) {
        return BeanValidationUtils.validate(obj, groups).isEmpty();
    }

    public static boolean isValidBeanIdentity(@NotNull Object obj) {
        return ValidBeanIdentity.ValidBeanIdentityValidator.isValid(obj);
    }

    public static boolean isValidBeanReference(@NotNull Object obj) {
        return ValidBeanReference.ValidBeanReferenceValidator.isValid(obj);
    }

    @NotNull
    public static <T> Set<ConstraintViolation<T>> validate(@NotNull T obj, Class<?> ... groups) {
        return validator.validate(obj, (Class[])groups);
    }
}

