/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.AbstractSimpleIdentity;
import dev.orne.beans.IdentityTokenFormatter;
import dev.orne.beans.IdentityTokenResolver;
import dev.orne.beans.UnrecognizedIdentityTokenException;
import dev.orne.test.rnd.GeneratorMethod;
import java.math.BigInteger;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class BigIntegerIdentity
extends AbstractSimpleIdentity<BigInteger> {
    private static final long serialVersionUID = 5660267975323191055L;

    @GeneratorMethod
    public BigIntegerIdentity(BigInteger value) {
        super(value);
    }

    public BigIntegerIdentity(@NotNull BigIntegerIdentity copy) {
        super(copy);
    }

    @IdentityTokenResolver
    @NotNull
    public static BigIntegerIdentity fromIdentityToken(@NotNull String token) throws UnrecognizedIdentityTokenException {
        return new BigIntegerIdentity(BigIntegerIdentity.extractTokenValue("", token));
    }

    public static BigInteger extractTokenValue(@NotNull String prefix, @NotNull String token) {
        String body = IdentityTokenFormatter.parse(prefix, token);
        if (body == null) {
            return null;
        }
        try {
            return new BigInteger(body);
        }
        catch (NumberFormatException nfe) {
            throw new UnrecognizedIdentityTokenException("Unrecognized identity token: " + token, nfe);
        }
    }

    @NotNull
    public static BigInteger extractRequiredTokenValue(@NotNull String prefix, @NotNull String token) {
        BigInteger result = BigIntegerIdentity.extractTokenValue(prefix, token);
        if (result == null) {
            throw new UnrecognizedIdentityTokenException("Unrecognized identity token: " + token);
        }
        return result;
    }
}

