/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.Identity;
import dev.orne.beans.IdentityTokenResolver;
import dev.orne.beans.UnrecognizedIdentityTokenException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.WeakHashMap;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE, since="0.1")
public class IdentityResolver {
    private static final Logger LOG = LoggerFactory.getLogger(IdentityResolver.class);
    private static final Cache SHARED_CACHE = new WeakHashMapCache();
    private static final String ERR_UNRESOLVABLE_TOKEN = "Identity token cannot be resolved";
    private static final String ERR_MISCONFIGURED = "Identity token cannot be resolved for misconfigured identity type";
    private static final String HELP_MISCONFIGURED = "Identity type '{}' resolution is misconfigured. See IdentityResolver javadoc for correct Identity resolution configuration. No further resolution attempts will succed.";
    private static final String ERR_NO_RESOLVER = "Identity type '%s' does not have any valid identity token resolution method or constructor";
    private static final String ERR_UNEXPECTED_RESOLVER_TYPE = "Unexpected Executable subtype for '%s' identity type: %s";
    private static final String ERR_GET_RESOLVER_ERROR = "Unexpected error analyzing '%s' identity type";
    private static final int RESOLVER_METHOD_MODIFIERS = 9;
    private static final String ERR_RESOLVER_METHOD_MODIFIERS = "Invalid modifiers in annotated token resolution method '%s' for identity type '%s'. Method must be public and static.";
    private static final String ERR_RESOLVER_METHOD_PARAMS = "Invalid parameter types in annotated token resolution method '%s' for identity type '%s'. Method must have one only argument of String type.";
    private static final String ERR_RESOLVER_METHOD_RETURN_TYPE = "Invalid return type in annotated token resolution method '%s' for identity type '%s'. Method must return identity type.";
    private static final String ERR_TOKEN_CONSTRUCTOR_NOT_FOUND = "No identity token contructor for identity type '%s'.";
    @NotNull
    private Cache cache = SHARED_CACHE;

    protected IdentityResolver() {
    }

    @NotNull
    public static IdentityResolver getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @NotNull
    protected Cache getCache() {
        return this.cache;
    }

    @NotNull
    protected IdentityResolver setCache(Cache cache) {
        this.cache = cache == null ? SHARED_CACHE : cache;
        return this;
    }

    public <T extends Identity> T resolve(Identity identity, @NotNull Class<T> targetType) throws UnrecognizedIdentityTokenException {
        Validate.notNull(targetType);
        if (identity == null || targetType.isInstance(identity)) {
            return (T)((Identity)targetType.cast(identity));
        }
        return this.resolve(identity.getIdentityToken(), targetType);
    }

    public <T extends Identity> T resolve(String identityToken, @NotNull Class<T> targetType) throws UnrecognizedIdentityTokenException {
        Validate.notNull(targetType);
        if (identityToken == null) {
            return null;
        }
        try {
            Executable resolver = this.getResolver(targetType);
            if (resolver instanceof Method) {
                return (T)((Identity)targetType.cast(((Method)resolver).invoke(null, identityToken)));
            }
            if (resolver instanceof Constructor) {
                return (T)((Identity)targetType.cast(((Constructor)resolver).newInstance(identityToken)));
            }
            throw new UnresolvableIdentityException(String.format(ERR_UNEXPECTED_RESOLVER_TYPE, targetType, resolver.getClass()));
        }
        catch (UnresolvableIdentityException uie) {
            throw new UnrecognizedIdentityTokenException(ERR_MISCONFIGURED, uie);
        }
        catch (InvocationTargetException ite) {
            if (!(ite.getTargetException() instanceof UnrecognizedIdentityTokenException)) {
                throw new UnrecognizedIdentityTokenException(ERR_UNRESOLVABLE_TOKEN, ite.getTargetException());
            }
            throw (UnrecognizedIdentityTokenException)ite.getTargetException();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new UnrecognizedIdentityTokenException(ERR_UNRESOLVABLE_TOKEN, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Executable getResolver(@NotNull Class<? extends Identity> targetType) throws UnresolvableIdentityException {
        Constructor<? extends Identity> resolver;
        Validate.notNull(targetType);
        Cache cache = this.cache;
        synchronized (cache) {
            if (this.cache.contains(targetType)) {
                resolver = this.cache.get(targetType);
            } else {
                try {
                    resolver = this.findTokenResolverMethod(targetType);
                    if (resolver == null) {
                        resolver = this.findTokenConstructor(targetType);
                    }
                    this.cache.put(targetType, resolver);
                }
                catch (UnresolvableIdentityException uie) {
                    LOG.warn(HELP_MISCONFIGURED, targetType);
                    this.cache.put(targetType, null);
                    throw uie;
                }
                catch (RuntimeException re) {
                    LOG.warn(HELP_MISCONFIGURED, targetType);
                    this.cache.put(targetType, null);
                    throw new UnresolvableIdentityException(ERR_GET_RESOLVER_ERROR, re);
                }
            }
        }
        if (resolver == null) {
            throw new UnresolvableIdentityException(String.format(ERR_NO_RESOLVER, targetType));
        }
        return resolver;
    }

    protected Method findTokenResolverMethod(@NotNull Class<?> targetType) throws UnresolvableIdentityException {
        Validate.notNull(targetType);
        Method resolver = null;
        for (Method method : targetType.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(IdentityTokenResolver.class)) continue;
            if ((method.getModifiers() & 9) != 9) {
                throw new UnresolvableIdentityException(String.format(ERR_RESOLVER_METHOD_MODIFIERS, method, targetType));
            }
            if (!Arrays.equals(new Class[]{String.class}, method.getParameterTypes())) {
                throw new UnresolvableIdentityException(String.format(ERR_RESOLVER_METHOD_PARAMS, method, targetType));
            }
            if (!targetType.isAssignableFrom(method.getReturnType())) {
                throw new UnresolvableIdentityException(String.format(ERR_RESOLVER_METHOD_RETURN_TYPE, method, targetType));
            }
            resolver = method;
            break;
        }
        return resolver;
    }

    protected <T> Constructor<T> findTokenConstructor(@NotNull Class<T> targetType) throws UnresolvableIdentityException {
        Validate.notNull(targetType);
        try {
            return targetType.getConstructor(String.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new UnresolvableIdentityException(String.format(ERR_TOKEN_CONSTRUCTOR_NOT_FOUND, targetType), nsme);
        }
    }

    @API(status=API.Status.INTERNAL, since="0.1")
    protected static interface Cache {
        public boolean contains(@NotNull Class<? extends Identity> var1);

        public Executable get(@NotNull Class<? extends Identity> var1);

        public void put(@NotNull Class<? extends Identity> var1, Executable var2);
    }

    @API(status=API.Status.INTERNAL, since="0.1")
    private static class InstanceHolder {
        private static final IdentityResolver INSTANCE = new IdentityResolver();

        private InstanceHolder() {
        }
    }

    @API(status=API.Status.STABLE, since="0.1")
    public static class UnresolvableIdentityException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnresolvableIdentityException() {
        }

        public UnresolvableIdentityException(String message) {
            super(message);
        }

        public UnresolvableIdentityException(Throwable cause) {
            super(cause);
        }

        public UnresolvableIdentityException(String message, Throwable cause) {
            super(message, cause);
        }

        public UnresolvableIdentityException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }

    @API(status=API.Status.INTERNAL, since="0.1")
    protected static class WeakHashMapCache
    implements Cache {
        private final WeakHashMap<Class<? extends Identity>, Executable> entries = new WeakHashMap();

        @Override
        public synchronized boolean contains(@NotNull Class<? extends Identity> key) {
            return this.entries.containsKey(key);
        }

        @Override
        public synchronized Executable get(@NotNull Class<? extends Identity> key) {
            return this.entries.get(key);
        }

        @Override
        public synchronized void put(@NotNull Class<? extends Identity> key, Executable value) {
            this.entries.put(key, value);
        }
    }
}

