/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.UnrecognizedIdentityTokenException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="0.1")
public final class IdentityTokenFormatter {
    public static final String TOKEN_CHAR = "[\\w-]";
    public static final String PREFIX = "^[\\w-]*$";
    public static final String UNENCODED_BODY_STARTING_CHAR = "[a-zA-Z0-9-]";
    public static final String UNENCODED_BODY = "[a-zA-Z0-9-][\\w-]*";
    public static final String ENCODED_BODY_PREFIX = "_";
    public static final String NULL_BODY = "_";
    public static final String ENCODED_BODY = "_[\\w-]*";
    public static final String BODY = "(?:|[a-zA-Z0-9-][\\w-]*|_[\\w-]*)";
    public static final String TOKEN = "^[\\w-]*$";
    private static final char B32_PADDING_CHAR = '=';
    public static final String DEFAULT_PREFIX = "";
    protected static final Predicate<String> VALID_PREFIX_PREDICATE = Pattern.compile("^[\\w-]*$").asPredicate();
    protected static final Predicate<String> VALID_UNENCODED_BODY_PREDICATE = Pattern.compile("^[a-zA-Z0-9-][\\w-]*$").asPredicate();
    protected static final Predicate<String> VALID_ENCODED_BODY_PREDICATE = Pattern.compile("^_[\\w-]*$").asPredicate();
    protected static final Predicate<String> VALID_BODY_PREDICATE = Pattern.compile("^(?:|[a-zA-Z0-9-][\\w-]*|_[\\w-]*)$").asPredicate();
    protected static final Predicate<String> VALID_TOKEN_PREDICATE = Pattern.compile("^[\\w-]*$").asPredicate();
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder();
    private static final Base64.Decoder DECODER = Base64.getUrlDecoder();

    private IdentityTokenFormatter() {
    }

    @NotNull
    protected static String encodeBody(String body) {
        String result;
        if (body == null) {
            result = "_";
        } else if (body.isEmpty() || VALID_UNENCODED_BODY_PREDICATE.test(body)) {
            result = body;
        } else {
            String b64 = ENCODER.encodeToString(body.getBytes(StandardCharsets.UTF_8));
            String b64NoPadding = b64.replaceAll(String.valueOf('='), DEFAULT_PREFIX);
            result = "_" + b64NoPadding;
        }
        return result;
    }

    protected static String decodeBody(@NotNull String encoded) throws UnrecognizedIdentityTokenException {
        String result;
        Validate.notNull((Object)encoded, (String)"Encoded identity token body is required", (Object[])new Object[0]);
        if (!VALID_BODY_PREDICATE.test(encoded)) {
            throw new UnrecognizedIdentityTokenException(String.format("Invalid identity token body: %s", encoded));
        }
        if (encoded.isEmpty()) {
            result = encoded;
        } else if ("_".equals(encoded)) {
            result = null;
        } else if (encoded.startsWith("_")) {
            String b64 = encoded.substring(1);
            if (b64.length() % 3 != 0) {
                b64 = StringUtils.rightPad((String)b64, (int)(3 - b64.length() % 3), (char)'=');
            }
            result = new String(DECODER.decode(b64), StandardCharsets.UTF_8);
        } else {
            result = encoded;
        }
        return result;
    }

    @NotNull
    public static String format(String body) {
        return IdentityTokenFormatter.format(DEFAULT_PREFIX, body);
    }

    @NotNull
    public static String format(@NotNull String prefix, String body) {
        Validate.notNull((Object)prefix, (String)"Identity token prefix is required", (Object[])new Object[0]);
        if (!VALID_PREFIX_PREDICATE.test(prefix)) {
            throw new IllegalArgumentException(String.format("Identity token prefix is not valid: %s", prefix));
        }
        return prefix + IdentityTokenFormatter.encodeBody(body);
    }

    public static boolean isValidPrefix(@NotNull String prefix) {
        return VALID_PREFIX_PREDICATE.test(prefix);
    }

    public static boolean isValidBody(@NotNull String body) {
        return VALID_BODY_PREDICATE.test(body);
    }

    public static boolean isValidUncodedBody(@NotNull String body) {
        return VALID_UNENCODED_BODY_PREDICATE.test(body);
    }

    public static boolean isValidEncodedBody(@NotNull String body) {
        return VALID_ENCODED_BODY_PREDICATE.test(body);
    }

    public static boolean isValidToken(@NotNull String token) {
        return VALID_TOKEN_PREDICATE.test(token);
    }

    public static String parse(@NotNull String token) throws UnrecognizedIdentityTokenException {
        return IdentityTokenFormatter.parse(DEFAULT_PREFIX, token);
    }

    public static String parse(@NotNull String prefix, @NotNull String token) throws UnrecognizedIdentityTokenException {
        Validate.notNull((Object)prefix, (String)"Identity token prefix is required", (Object[])new Object[0]);
        if (!VALID_PREFIX_PREDICATE.test(prefix)) {
            throw new IllegalArgumentException(String.format("Identity token prefix is not valid: %s", prefix));
        }
        Validate.notNull((Object)token, (String)"Identity token is required", (Object[])new Object[0]);
        if (!VALID_TOKEN_PREDICATE.test(token)) {
            throw new UnrecognizedIdentityTokenException(String.format("Invalid identity token: %s", token));
        }
        if (!token.startsWith(prefix)) {
            throw new UnrecognizedIdentityTokenException(String.format("Unrecognized identity token: %s", token));
        }
        return IdentityTokenFormatter.decodeBody(token.substring(prefix.length()));
    }
}

