/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL, since="0.6")
public class JacksonSpiTypeIdResolver
extends TypeIdResolverBase {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonSpiTypeIdResolver.class);
    @NotNull
    private final Map<String, Class<?>> subtypes = new HashMap();
    private static final String REPEATED_ERR = "Annotated type [%s] got repeated subtype name [%s]";

    @NotNull
    public Map<String, Class<?>> getSubtypes() {
        return Collections.unmodifiableMap(this.subtypes);
    }

    public void init(@NotNull JavaType bt) {
        super.init((JavaType)Validate.notNull((Object)bt));
        Class bc = bt.getRawClass();
        if (bc.isAnnotationPresent(JsonTypeIdResolver.class)) {
            this.subtypes.putAll(this.getRegisteredSubTypes(bc));
        } else {
            this.subtypes.putAll(this.findInheritedSubTypes(bc).entrySet().stream().filter(entry -> bc.isAssignableFrom((Class)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(@NotNull Object value) {
        return this.getIdFromBean(Validate.notNull((Object)value));
    }

    public String idFromValueAndType(Object value, @NotNull Class<?> suggestedType) {
        return value == null ? this.getIdFromAnnotation(suggestedType) : this.idFromValue(value);
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        JavaType result;
        Class<?> type = id != null && this.subtypes.containsKey(id) ? this.subtypes.get(id) : null;
        if (type == null) {
            LOG.debug("Unresolved ID {}. Using default implementation (if any)...", (Object)id);
            result = null;
        } else if (context == null) {
            LOG.debug("Resolved ID {} to type {}", (Object)id, type);
            result = TypeFactory.defaultInstance().constructType(type);
        } else {
            LOG.debug("Resolved ID {} to type {}", (Object)id, type);
            result = context.constructType(type);
        }
        return result;
    }

    @NotNull
    protected Map<String, Class<?>> getRegisteredSubTypes(@NotNull Class<?> baseClass) {
        ServiceLoader<?> loader = ServiceLoader.load(baseClass);
        HashMap result = new HashMap();
        for (Object bean : loader) {
            Class<?> type = bean.getClass();
            String id = this.getIdFromBean(bean);
            this.checkForRepeatedName(result, id, type);
            result.put(id, type);
        }
        return result;
    }

    @NotNull
    protected Map<String, Class<?>> findInheritedSubTypes(@NotNull Class<?> type) {
        JsonTypeIdResolver annot = type.getAnnotation(JsonTypeIdResolver.class);
        Map<String, Class<?>> result = annot != null ? this.getRegisteredSubTypes(type) : new HashMap();
        for (Class<?> interf : type.getInterfaces()) {
            Map<String, Class<?>> inherited = this.findInheritedSubTypes(interf);
            for (Map.Entry<String, Class<?>> entry : inherited.entrySet()) {
                this.checkForRepeatedName(result, entry.getKey(), entry.getValue());
                result.put(entry.getKey(), entry.getValue());
            }
        }
        if (!type.isInterface() && type.getSuperclass() != Object.class) {
            Map<String, Class<?>> inherited = this.findInheritedSubTypes(type.getSuperclass());
            for (Map.Entry<String, Class<?>> entry : inherited.entrySet()) {
                this.checkForRepeatedName(result, entry.getKey(), entry.getValue());
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    protected void checkForRepeatedName(@NotNull Map<String, Class<?>> known, @NotNull String id, @NotNull Class<?> type) {
        if (known.containsKey(id) && !known.get(id).equals(type)) {
            throw new IllegalArgumentException(String.format(REPEATED_ERR, type, id));
        }
    }

    @NotNull
    protected String getIdFromBean(@NotNull Object bean) {
        String id = this.getIdFromAnnotation(bean.getClass());
        if (id == null) {
            id = JacksonSpiTypeIdResolver.defaultTypeId(bean.getClass());
        }
        return id;
    }

    protected String getIdFromAnnotation(Class<?> type) {
        JsonTypeName annot = type.getAnnotation(JsonTypeName.class);
        String name = annot == null ? null : annot.value();
        return name;
    }

    public static String defaultTypeId(@NotNull Class<?> cls) {
        return JacksonSpiTypeIdResolver.defaultTypeId(cls.getName());
    }

    public static String defaultTypeId(@NotNull String clsName) {
        int index = clsName.lastIndexOf(46);
        String id = index < 0 ? clsName : clsName.substring(index + 1);
        return id;
    }
}

