/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.AbstractSimpleIdentity;
import dev.orne.beans.IdentityTokenFormatter;
import dev.orne.beans.IdentityTokenResolver;
import dev.orne.beans.UnrecognizedIdentityTokenException;
import dev.orne.test.rnd.GeneratorMethod;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class LongIdentity
extends AbstractSimpleIdentity<Long> {
    private static final long serialVersionUID = 5660267975323191055L;

    @GeneratorMethod
    public LongIdentity(Long value) {
        super(value);
    }

    public LongIdentity(@NotNull LongIdentity copy) {
        super(copy);
    }

    @IdentityTokenResolver
    @NotNull
    public static LongIdentity fromIdentityToken(@NotNull String token) throws UnrecognizedIdentityTokenException {
        return new LongIdentity(LongIdentity.extractTokenValue("", token));
    }

    public static Long extractTokenValue(@NotNull String prefix, @NotNull String token) {
        String body = IdentityTokenFormatter.parse(prefix, token);
        if (body == null) {
            return null;
        }
        try {
            return Long.parseLong(body);
        }
        catch (NumberFormatException nfe) {
            throw new UnrecognizedIdentityTokenException("Unrecognized identity token: " + token, nfe);
        }
    }

    @NotNull
    public static Long extractRequiredTokenValue(@NotNull String prefix, @NotNull String token) {
        Long result = LongIdentity.extractTokenValue(prefix, token);
        if (result == null) {
            throw new UnrecognizedIdentityTokenException("Unrecognized identity token: " + token);
        }
        return result;
    }
}

