/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.AbstractSimpleIdentity;
import dev.orne.beans.IdentityTokenFormatter;
import dev.orne.beans.IdentityTokenResolver;
import dev.orne.beans.UnrecognizedIdentityTokenException;
import dev.orne.test.rnd.GeneratorMethod;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class StringIdentity
extends AbstractSimpleIdentity<String> {
    private static final long serialVersionUID = 5660267975323191055L;

    @GeneratorMethod
    public StringIdentity(String value) {
        super(value);
    }

    public StringIdentity(@NotNull StringIdentity copy) {
        super(copy);
    }

    @IdentityTokenResolver
    @NotNull
    public static StringIdentity fromIdentityToken(@NotNull String token) {
        return new StringIdentity(StringIdentity.extractTokenValue("", token));
    }

    public static String extractTokenValue(@NotNull String prefix, @NotNull String token) {
        return IdentityTokenFormatter.parse(prefix, token);
    }

    @NotNull
    public static String extractRequiredTokenValue(@NotNull String prefix, @NotNull String token) {
        String result = StringIdentity.extractTokenValue(prefix, token);
        if (result == null) {
            throw new UnrecognizedIdentityTokenException("Unrecognized identity token: " + token);
        }
        return result;
    }
}

