/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import com.fasterxml.jackson.annotation.JsonCreator;
import dev.orne.beans.Identity;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class TokenIdentity
implements Identity {
    private static final long serialVersionUID = -1L;
    private final String identityToken;

    public TokenIdentity(@NotNull String token) {
        Validate.notBlank((CharSequence)token);
        this.identityToken = token;
    }

    @Override
    @NotBlank
    public String getIdentityToken() {
        return this.identityToken;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getClass()).append((Object)this.identityToken).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TokenIdentity other = (TokenIdentity)obj;
        return new EqualsBuilder().append((Object)this.identityToken, (Object)other.identityToken).isEquals();
    }

    public String toString() {
        return this.identityToken;
    }

    @JsonCreator
    public static TokenIdentity fromToken(String token) {
        TokenIdentity result = token == null || token.isEmpty() ? null : new TokenIdentity(token);
        return result;
    }

    @API(status=API.Status.INTERNAL, since="0.1")
    public static class IdentityXmlAdapter
    extends XmlAdapter<String, Identity> {
        public TokenIdentity unmarshal(String value) {
            TokenIdentity result = value == null || value.isEmpty() ? null : new TokenIdentity(value);
            return result;
        }

        public String marshal(Identity identity) {
            String token;
            String result = identity == null ? null : (StringUtils.isEmpty((CharSequence)(token = identity.getIdentityToken())) ? null : identity.getIdentityToken());
            return result;
        }
    }
}

