/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.BeanValidationUtils;
import dev.orne.beans.IdentityBean;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
@Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={ValidBeanIdentityValidator.class})
@ReportAsSingleViolation
public @interface ValidBeanIdentity {
    public String message() default "{dev.orne.beans.ValidBeanIdentity.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    @API(status=API.Status.INTERNAL, since="0.1")
    public static class ValidBeanIdentityValidator
    implements ConstraintValidator<ValidBeanIdentity, Object> {
        public boolean isValid(Object value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            boolean valid = true;
            if (value instanceof Iterable || value.getClass().isArray()) {
                Object obj;
                List<Object> iterable = value instanceof Iterable ? (List<Object>)value : Arrays.asList((Object[])value);
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext() && (valid = ValidBeanIdentityValidator.isValid(obj = iterator.next()))) {
                }
            } else {
                valid = ValidBeanIdentityValidator.isValid(value);
            }
            return valid;
        }

        public static boolean isValid(@NotNull Object value) {
            return value instanceof IdentityBean && BeanValidationUtils.isValid(value, IdentityBean.RequireIdentity.class);
        }
    }
}

