/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans;

import dev.orne.beans.Identity;
import dev.orne.beans.IdentityResolver;
import dev.orne.beans.UnrecognizedIdentityTokenException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.4")
@Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Valid
@Constraint(validatedBy={ValidIdentityValidator.class, ValidIdentityValidatorForString.class})
@ReportAsSingleViolation
public @interface ValidIdentity {
    public Class<? extends Identity> value() default Identity.class;

    public String message() default "{dev.orne.beans.ValidIdentity.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    @API(status=API.Status.INTERNAL, since="0.4")
    public static class ValidIdentityValidatorForString
    implements ConstraintValidator<ValidIdentity, String> {
        @NotNull
        private Class<? extends Identity> expectedType;

        public void initialize(@NotNull ValidIdentity annotation) {
            this.expectedType = annotation.value();
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            boolean valid = true;
            if (value != null) {
                valid = ValidIdentityValidatorForString.isValid(value, this.expectedType);
            }
            return valid;
        }

        public static boolean isValid(@NotNull String value) {
            return ValidIdentityValidatorForString.isValid(value, Identity.class);
        }

        public static boolean isValid(@NotNull String value, @NotNull Class<? extends Identity> expectedType) {
            Validate.notNull((Object)value);
            Validate.notNull(expectedType);
            if (Identity.class.equals(expectedType)) {
                return true;
            }
            try {
                IdentityResolver.getInstance().resolve(value, expectedType);
                return true;
            }
            catch (UnrecognizedIdentityTokenException ignore) {
                return false;
            }
        }
    }

    @API(status=API.Status.INTERNAL, since="0.4")
    public static class ValidIdentityValidator
    implements ConstraintValidator<ValidIdentity, Identity> {
        @NotNull
        private Class<? extends Identity> expectedType;

        public void initialize(@NotNull ValidIdentity annotation) {
            this.expectedType = annotation.value();
        }

        public boolean isValid(Identity value, ConstraintValidatorContext context) {
            boolean valid = true;
            if (value != null) {
                valid = ValidIdentityValidator.isValid(value, this.expectedType);
            }
            return valid;
        }

        public static boolean isValid(@NotNull Identity value) {
            return ValidIdentityValidator.isValid(value, Identity.class);
        }

        public static boolean isValid(@NotNull Identity value, @NotNull Class<? extends Identity> expectedType) {
            Validate.notNull((Object)value);
            Validate.notNull(expectedType);
            if (expectedType.isInstance(value)) {
                return true;
            }
            try {
                IdentityResolver.getInstance().resolve(value, expectedType);
                return true;
            }
            catch (UnrecognizedIdentityTokenException ignore) {
                return false;
            }
        }
    }
}

