/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE, since="0.1")
public abstract class AbstractDateTimeConverter
extends AbstractConverter {
    @NotNull
    private final DateTimeFormatter formatter;
    @NotNull
    private final Set<DateTimeFormatter> parsers = new LinkedHashSet<DateTimeFormatter>();
    private Logger logger;

    protected AbstractDateTimeConverter(@NotNull DateTimeFormatter formatter) {
        this.formatter = formatter;
        this.parsers.add(formatter);
    }

    protected AbstractDateTimeConverter(@NotNull DateTimeFormatter formatter, TemporalAccessor defaultValue) {
        super((Object)defaultValue);
        this.formatter = formatter;
        this.parsers.add(formatter);
    }

    @NotNull
    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    @NotNull
    public List<DateTimeFormatter> getParsers() {
        return Collections.unmodifiableList(new ArrayList<DateTimeFormatter>(this.parsers));
    }

    public void setParsers(DateTimeFormatter ... parsers) {
        this.setParsers(Arrays.asList(parsers));
    }

    public void setParsers(@NotNull Collection<DateTimeFormatter> parsers) {
        this.parsers.clear();
        this.parsers.addAll(parsers);
    }

    public void addParsers(DateTimeFormatter ... parsers) {
        this.addParsers(Arrays.asList(parsers));
    }

    public void addParsers(@NotNull Collection<DateTimeFormatter> parsers) {
        this.parsers.addAll(parsers);
    }

    protected abstract Class<?> getDefaultType();

    protected <T> T convertToType(@NotNull Class<T> type, Object value) {
        if (TemporalAccessor.class.isAssignableFrom(type)) {
            Class<T> temporalType = type;
            if (value instanceof TemporalAccessor) {
                return type.cast(this.fromTemporalAccessor(temporalType, (TemporalAccessor)value));
            }
            if (value instanceof Long) {
                return type.cast(this.fromTemporalAccessor(temporalType, Instant.ofEpochMilli((Long)value)));
            }
            if (value instanceof GregorianCalendar) {
                return type.cast(this.fromTemporalAccessor(temporalType, ((GregorianCalendar)value).toZonedDateTime()));
            }
            if (value instanceof Calendar) {
                return type.cast(this.fromTemporalAccessor(temporalType, ((Calendar)value).toInstant()));
            }
            if (value instanceof Date) {
                return type.cast(this.fromTemporalAccessor(temporalType, ((Date)value).toInstant()));
            }
            return type.cast(this.parseString(temporalType, value.toString()));
        }
        throw this.conversionException(type, value);
    }

    protected <T extends TemporalAccessor> T parseString(@NotNull Class<T> type, @NotNull String value) {
        DateTimeException firstException = null;
        for (DateTimeFormatter parser : this.parsers) {
            try {
                return (T)((TemporalAccessor)type.cast(this.parse(type, parser, value)));
            }
            catch (DateTimeException dte) {
                if (firstException == null) {
                    firstException = dte;
                } else {
                    firstException.addSuppressed(dte);
                }
                this.getLogger().debug("Failed to parse temporal value", (Throwable)dte);
            }
        }
        if (firstException == null) {
            throw this.conversionException(type, value);
        }
        throw firstException;
    }

    protected <T extends TemporalAccessor> T parse(@NotNull Class<T> type, @NotNull DateTimeFormatter parser, @NotNull String value) {
        return this.fromTemporalAccessor(type, parser.parse(value));
    }

    protected abstract <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> var1, @NotNull TemporalAccessor var2);

    protected String convertToString(Object value) {
        if (value instanceof TemporalAccessor) {
            return this.formatter.format((TemporalAccessor)value);
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw this.conversionException(String.class, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Logger getLogger() {
        AbstractDateTimeConverter abstractDateTimeConverter = this;
        synchronized (abstractDateTimeConverter) {
            if (this.logger == null) {
                this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            }
            return this.logger;
        }
    }
}

