/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.InstantConverter;
import java.time.Instant;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.3")
public class DateConverter
extends AbstractConverter {
    @NotNull
    private final Converter instantConverter;

    public DateConverter() {
        this.instantConverter = new InstantConverter();
    }

    public DateConverter(Date defaultValue) {
        super((Object)defaultValue);
        this.instantConverter = new InstantConverter(defaultValue == null ? null : defaultValue.toInstant());
    }

    public DateConverter(@NotNull Converter instantConverter) {
        this.instantConverter = instantConverter;
    }

    public DateConverter(@NotNull Converter instantConverter, Date defaultValue) {
        super((Object)defaultValue);
        this.instantConverter = instantConverter;
    }

    @NotNull
    protected Converter getInstantConverter() {
        return this.instantConverter;
    }

    @NotNull
    protected Class<Date> getDefaultType() {
        return Date.class;
    }

    protected <T> T convertToType(@NotNull Class<T> type, Object value) throws Throwable {
        if (type.isAssignableFrom(Date.class)) {
            Instant instant = (Instant)this.instantConverter.convert(Instant.class, value);
            if (instant == null) {
                return null;
            }
            return type.cast(Date.from(instant));
        }
        throw this.conversionException(type, value);
    }

    protected String convertToString(Object value) throws Throwable {
        if (value instanceof Date) {
            return (String)this.instantConverter.convert(String.class, (Object)((Date)value).toInstant());
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw this.conversionException(String.class, value);
    }
}

