/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import dev.orne.beans.converters.InstantConverter;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class DayOfWeekConverter
extends AbstractDateTimeConverter {
    public static final DateTimeFormatter BY_VALUE_PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.DAY_OF_WEEK).toFormatter();
    public static final DateTimeFormatter BY_FULL_TEXT_PARSER = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.FULL_STANDALONE).toFormatter();
    public static final DateTimeFormatter BY_SHORT_TEXT_PARSER = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.SHORT_STANDALONE).toFormatter();
    public static final DateTimeFormatter BY_NARROW_TEXT_PARSER = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.NARROW_STANDALONE).toFormatter();

    public DayOfWeekConverter() {
        super(BY_VALUE_PARSER);
        this.setDefaultParsers();
    }

    public DayOfWeekConverter(DayOfWeek defaultValue) {
        super(BY_VALUE_PARSER, defaultValue);
        this.setDefaultParsers();
    }

    public DayOfWeekConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public DayOfWeekConverter(@NotNull DateTimeFormatter formatter, DayOfWeek defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(BY_VALUE_PARSER, BY_FULL_TEXT_PARSER, BY_SHORT_TEXT_PARSER, BY_NARROW_TEXT_PARSER, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.ISO_WEEK_DATE, DateTimeFormatter.BASIC_ISO_DATE, InstantConverter.EPOCH_MILLIS_PARSER);
    }

    @Override
    @NotNull
    protected Class<?> getDefaultType() {
        return DayOfWeek.class;
    }

    @Override
    protected <T> T convertToType(@NotNull Class<T> type, Object value) {
        if (type.isAssignableFrom(DayOfWeek.class)) {
            if (value instanceof String) {
                try {
                    return type.cast(DayOfWeek.valueOf((String)value));
                }
                catch (IllegalArgumentException iae) {
                    this.getLogger().debug("Failed to parse value as constant name", (Throwable)iae);
                    return super.convertToType(type, value);
                }
            }
            if (value instanceof Number) {
                try {
                    return type.cast(DayOfWeek.of(((Number)value).intValue()));
                }
                catch (DateTimeException dte) {
                    this.getLogger().debug("Failed to parse value as constant value", (Throwable)dte);
                    return super.convertToType(type, value);
                }
            }
            return super.convertToType(type, value);
        }
        throw this.conversionException(type, value);
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        try {
            return (T)((TemporalAccessor)type.cast(DayOfWeek.from(value)));
        }
        catch (DateTimeException dte) {
            this.getLogger().debug("Failed to convert temporal accessor to DayOfWeek directly", (Throwable)dte);
            return (T)((TemporalAccessor)type.cast(Instant.from(value).atOffset(ZoneOffset.UTC).getDayOfWeek()));
        }
    }

    @Override
    protected String convertToString(Object value) {
        if (value instanceof DayOfWeek) {
            return ((DayOfWeek)value).name();
        }
        return super.convertToString(value);
    }
}

