/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import java.time.Duration;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class DurationConverter
extends AbstractConverter {
    public DurationConverter() {
    }

    public DurationConverter(Duration defaultValue) {
        super((Object)defaultValue);
    }

    @NotNull
    protected Class<?> getDefaultType() {
        return Duration.class;
    }

    protected <T> T convertToType(@NotNull Class<T> type, Object value) throws Throwable {
        if (type.isAssignableFrom(Duration.class)) {
            if (value instanceof Number) {
                return type.cast(Duration.ofMillis(((Number)value).longValue()));
            }
            if (value.toString().matches("[-\\+]?\\d+")) {
                return type.cast(Duration.ofMillis(Long.parseLong(value.toString())));
            }
            return type.cast(Duration.parse(value.toString()));
        }
        throw this.conversionException(type, value);
    }

    protected String convertToString(Object value) throws Throwable {
        if (value instanceof Duration) {
            return ((Duration)value).toString();
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw this.conversionException(String.class, value);
    }
}

