/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.lang3.Validate;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class EnumConverter
extends AbstractConverter {
    public static final EnumConverter GENERIC = new EnumConverter();
    public static final EnumConverter GENERIC_DEFAULT = new EnumConverter(null);

    private EnumConverter() {
    }

    private EnumConverter(Enum<?> defaultValue) {
        super(defaultValue);
    }

    @NotNull
    protected Class<?> getDefaultType() {
        return Enum.class;
    }

    protected <T> T convertToType(@NotNull Class<T> type, Object value) throws Throwable {
        if (type.isEnum()) {
            if (value == null) {
                return null;
            }
            Class<T> eType = type;
            return type.cast(this.enumFromName(eType, value.toString()));
        }
        throw this.conversionException(type, value);
    }

    protected <T> T enumFromName(@NotNull Class<T> type, @NotNull String name) {
        Validate.notNull(type);
        Validate.notNull((Object)name);
        T[] constants = type.getEnumConstants();
        if (constants == null) {
            throw this.conversionException(type, name);
        }
        for (T constant : constants) {
            if (!((Enum)constant).name().equals(name)) continue;
            return constant;
        }
        throw this.conversionException(type, name);
    }

    protected String convertToString(Object value) throws Throwable {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw this.conversionException(String.class, value);
    }

    public static void register() {
        BeanUtilsBean.getInstance().getConvertUtils().register((Converter)GENERIC, Enum.class);
    }

    public static void register(ConvertUtilsBean converter) {
        ((ConvertUtilsBean)Validate.notNull((Object)converter)).register((Converter)GENERIC, Enum.class);
    }

    public static void registerWithDefault() {
        BeanUtilsBean.getInstance().getConvertUtils().register((Converter)GENERIC_DEFAULT, Enum.class);
    }

    public static void registerWithDefault(ConvertUtilsBean converter) {
        ((ConvertUtilsBean)Validate.notNull((Object)converter)).register((Converter)GENERIC_DEFAULT, Enum.class);
    }
}

