/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import java.util.function.BiFunction;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.lang3.Validate;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class EnumTypedConverter<E extends Enum<E>>
extends AbstractConverter {
    private final Class<E> enumType;
    private final BiFunction<Class<E>, String, E> stringToEnum;
    private final Function<E, String> enumToString;

    public EnumTypedConverter(@NotNull Class<E> enumType) {
        this(enumType, Enum::valueOf, Enum::name);
    }

    public EnumTypedConverter(@NotNull Class<E> enumType, E defaultValue) {
        this((Class<Enum>)enumType, (BiFunction<Class<Enum>, String, Enum>)((BiFunction<Class, String, Enum>)Enum::valueOf), Enum::name, (Enum)defaultValue);
    }

    public EnumTypedConverter(@NotNull Class<E> enumType, @NotNull BiFunction<Class<E>, String, E> stringToEnum, @NotNull Function<E, String> enumToString) {
        this.enumType = (Class)Validate.notNull(enumType);
        this.stringToEnum = (BiFunction)Validate.notNull(stringToEnum);
        this.enumToString = (Function)Validate.notNull(enumToString);
    }

    public EnumTypedConverter(@NotNull Class<E> enumType, @NotNull BiFunction<Class<E>, String, E> stringToEnum, @NotNull Function<E, String> enumToString, E defaultValue) {
        super(defaultValue);
        this.enumType = (Class)Validate.notNull(enumType);
        this.stringToEnum = (BiFunction)Validate.notNull(stringToEnum);
        this.enumToString = (Function)Validate.notNull(enumToString);
    }

    public static <T extends Enum<T>> EnumTypedConverter<T> of(Class<T> enumType) {
        return new EnumTypedConverter<T>(enumType);
    }

    public static <T extends Enum<T>> EnumTypedConverter<T> of(Class<T> enumType, T defaultValue) {
        return new EnumTypedConverter<T>(enumType, defaultValue);
    }

    public static <T extends Enum<T>> void registerFor(Class<T> enumType) {
        BeanUtilsBean.getInstance().getConvertUtils().register(new EnumTypedConverter<T>(enumType), enumType);
    }

    public static <T extends Enum<T>> void registerFor(ConvertUtilsBean converter, Class<T> enumType) {
        ((ConvertUtilsBean)Validate.notNull((Object)converter)).register(new EnumTypedConverter<T>(enumType), enumType);
    }

    public static <T extends Enum<T>> void registerFor(Class<T> enumType, T defaultValue) {
        BeanUtilsBean.getInstance().getConvertUtils().register(new EnumTypedConverter<T>(enumType, defaultValue), enumType);
    }

    public static <T extends Enum<T>> void registerFor(ConvertUtilsBean converter, Class<T> enumType, T defaultValue) {
        ((ConvertUtilsBean)Validate.notNull((Object)converter)).register(new EnumTypedConverter<T>(enumType, defaultValue), enumType);
    }

    @NotNull
    protected Class<?> getDefaultType() {
        return this.enumType;
    }

    protected <T> T convertToType(@NotNull Class<T> type, Object value) throws Throwable {
        if (type.isAssignableFrom(this.enumType)) {
            if (value == null) {
                return null;
            }
            return type.cast(this.stringToEnum.apply(this.enumType, value.toString()));
        }
        throw this.conversionException(type, value);
    }

    protected String convertToString(Object value) throws Throwable {
        if (this.enumType.isInstance(value)) {
            return this.enumToString.apply((Enum)this.enumType.cast(value));
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw this.conversionException(String.class, value);
    }
}

