/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.ZonedDateTimeConverter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.3")
public class GregorianCalendarConverter
extends AbstractConverter {
    @NotNull
    private final Converter zonedDateTimeConverter;

    public GregorianCalendarConverter() {
        this.zonedDateTimeConverter = new ZonedDateTimeConverter();
    }

    public GregorianCalendarConverter(GregorianCalendar defaultValue) {
        super((Object)defaultValue);
        this.zonedDateTimeConverter = new ZonedDateTimeConverter(defaultValue == null ? null : defaultValue.toZonedDateTime());
    }

    public GregorianCalendarConverter(@NotNull Converter instantConverter) {
        this.zonedDateTimeConverter = instantConverter;
    }

    public GregorianCalendarConverter(@NotNull Converter instantConverter, GregorianCalendar defaultValue) {
        super((Object)defaultValue);
        this.zonedDateTimeConverter = instantConverter;
    }

    @NotNull
    protected Converter getZonedDateTimeConverter() {
        return this.zonedDateTimeConverter;
    }

    @NotNull
    protected Class<GregorianCalendar> getDefaultType() {
        return GregorianCalendar.class;
    }

    protected <T> T convertToType(@NotNull Class<T> type, Object value) throws Throwable {
        if (type.isAssignableFrom(GregorianCalendar.class)) {
            if (type.isInstance(value)) {
                return type.cast(value);
            }
            ZonedDateTime instant = (ZonedDateTime)this.zonedDateTimeConverter.convert(ZonedDateTime.class, value);
            if (instant == null) {
                return null;
            }
            return type.cast(GregorianCalendar.from(instant));
        }
        throw this.conversionException(type, value);
    }

    protected String convertToString(Object value) throws Throwable {
        if (value instanceof Calendar) {
            ZonedDateTime zdt = value instanceof GregorianCalendar ? ((GregorianCalendar)value).toZonedDateTime() : ZonedDateTime.ofInstant(((Calendar)value).toInstant(), ZoneId.systemDefault());
            return (String)this.zonedDateTimeConverter.convert(String.class, (Object)zdt);
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw this.conversionException(String.class, value);
    }
}

