/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.BaseIdentityBean;
import dev.orne.beans.Identity;
import dev.orne.beans.IdentityBean;
import dev.orne.beans.WritableIdentityBean;
import dev.orne.beans.converters.IdentityConverter;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.3")
public class IdentityBeanConverter
extends AbstractConverter {
    private static final String NOT_WRITABLE_IBEAN_ERROR = "Can't convert value '%s' to type %s. Target type does not implement %s";
    private static final String NEW_INSTANCE_ERROR = "Can't convert value '%s' to type %s. Cannot create new instances of target type";
    private final Class<? extends WritableIdentityBean> defaultType;
    private final Converter identityConverter;

    public IdentityBeanConverter() {
        this.defaultType = BaseIdentityBean.class;
        this.identityConverter = new IdentityConverter();
    }

    public IdentityBeanConverter(IdentityBean defaultValue) {
        super((Object)defaultValue);
        this.defaultType = BaseIdentityBean.class;
        this.identityConverter = new IdentityConverter();
    }

    public IdentityBeanConverter(@NotNull Converter identityConverter) {
        this.defaultType = BaseIdentityBean.class;
        this.identityConverter = identityConverter;
    }

    public IdentityBeanConverter(@NotNull Converter identityConverter, WritableIdentityBean defaultValue) {
        super((Object)defaultValue);
        this.defaultType = BaseIdentityBean.class;
        this.identityConverter = identityConverter;
    }

    public IdentityBeanConverter(@NotNull Class<? extends WritableIdentityBean> defaultType) {
        this.defaultType = defaultType;
        this.identityConverter = new IdentityConverter();
    }

    public <T extends WritableIdentityBean> IdentityBeanConverter(@NotNull Class<T> defaultType, T defaultValue) {
        super(defaultValue);
        this.defaultType = defaultType;
        this.identityConverter = new IdentityConverter();
    }

    public IdentityBeanConverter(@NotNull Class<? extends WritableIdentityBean> defaultType, @NotNull Converter identityConverter) {
        this.defaultType = defaultType;
        this.identityConverter = identityConverter;
    }

    public <T extends WritableIdentityBean> IdentityBeanConverter(@NotNull Class<T> defaultType, @NotNull Converter identityConverter, T defaultValue) {
        super(defaultValue);
        this.defaultType = defaultType;
        this.identityConverter = identityConverter;
    }

    protected Converter getIdentityConverter() {
        return this.identityConverter;
    }

    @NotNull
    protected Class<?> getDefaultType() {
        return this.defaultType == null ? WritableIdentityBean.class : this.defaultType;
    }

    protected <T> T convertToType(@NotNull Class<T> type, Object value) {
        if (IdentityBean.class.isAssignableFrom(type)) {
            if (type.isInstance(value)) {
                return type.cast(value);
            }
            if (WritableIdentityBean.class.isAssignableFrom(type)) {
                Identity identity = this.convertIdentity(value);
                if (identity == null) {
                    return null;
                }
                T bean = this.createInstance(type, value);
                ((WritableIdentityBean)bean).setIdentity(identity);
                return bean;
            }
            throw new ConversionException(String.format(NOT_WRITABLE_IBEAN_ERROR, value, type, WritableIdentityBean.class));
        }
        throw this.conversionException(type, value);
    }

    protected <T> T createInstance(@NotNull Class<T> type, Object value) {
        try {
            return (T)ConstructorUtils.invokeConstructor(type, (Object[])new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConversionException(String.format(NEW_INSTANCE_ERROR, value, type), (Throwable)e);
        }
    }

    protected Identity convertIdentity(Object value) {
        Identity identity = value instanceof Identity ? (Identity)value : (Identity)this.identityConverter.convert(Identity.class, value);
        return identity;
    }

    protected String convertToString(Object value) throws Throwable {
        if (value instanceof IdentityBean) {
            return (String)this.identityConverter.convert(String.class, (Object)((IdentityBean)value).getIdentity());
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw this.conversionException(String.class, value);
    }
}

