/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class InstantConverter
extends AbstractDateTimeConverter {
    public static final DateTimeFormatter EPOCH_MILLIS_PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.INSTANT_SECONDS, 1, 19, SignStyle.NEVER).appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();

    public InstantConverter() {
        super(DateTimeFormatter.ISO_INSTANT);
        this.setDefaultParsers();
    }

    public InstantConverter(Instant defaultValue) {
        super(DateTimeFormatter.ISO_INSTANT, defaultValue);
        this.setDefaultParsers();
    }

    public InstantConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public InstantConverter(@NotNull DateTimeFormatter formatter, Instant defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_DATE_TIME, EPOCH_MILLIS_PARSER);
    }

    @NotNull
    protected Class<Instant> getDefaultType() {
        return Instant.class;
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        try {
            return (T)((TemporalAccessor)type.cast(Instant.from(value)));
        }
        catch (DateTimeException dte) {
            this.getLogger().debug("Failed to convert temporal accessor to Instant directly", (Throwable)dte);
            return (T)((TemporalAccessor)type.cast(LocalDateTime.from(value).toInstant(ZoneOffset.UTC)));
        }
    }
}

