/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import dev.orne.beans.converters.InstantConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class LocalDateConverter
extends AbstractDateTimeConverter {
    public LocalDateConverter() {
        super(DateTimeFormatter.ISO_LOCAL_DATE);
        this.setDefaultParsers();
    }

    public LocalDateConverter(LocalDate defaultValue) {
        super(DateTimeFormatter.ISO_LOCAL_DATE, defaultValue);
        this.setDefaultParsers();
    }

    public LocalDateConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public LocalDateConverter(@NotNull DateTimeFormatter formatter, LocalDate defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.ISO_WEEK_DATE, DateTimeFormatter.BASIC_ISO_DATE, InstantConverter.EPOCH_MILLIS_PARSER);
    }

    @Override
    @NotNull
    protected Class<?> getDefaultType() {
        return LocalDate.class;
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        try {
            return (T)((TemporalAccessor)type.cast(LocalDate.from(value)));
        }
        catch (DateTimeException dte) {
            this.getLogger().debug("Failed to convert temporal accessor to local date directly", (Throwable)dte);
            return (T)((TemporalAccessor)type.cast(Instant.from(value).atZone(ZoneOffset.UTC).toLocalDate()));
        }
    }
}

