/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import dev.orne.beans.converters.InstantConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class LocalTimeConverter
extends AbstractDateTimeConverter {
    public LocalTimeConverter() {
        super(DateTimeFormatter.ISO_LOCAL_TIME);
        this.setDefaultParsers();
    }

    public LocalTimeConverter(LocalTime defaultValue) {
        super(DateTimeFormatter.ISO_LOCAL_TIME, defaultValue);
        this.setDefaultParsers();
    }

    public LocalTimeConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public LocalTimeConverter(@NotNull DateTimeFormatter formatter, LocalTime defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_TIME, InstantConverter.EPOCH_MILLIS_PARSER);
    }

    @Override
    @NotNull
    protected Class<?> getDefaultType() {
        return LocalTime.class;
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        try {
            return (T)((TemporalAccessor)type.cast(LocalTime.from(value)));
        }
        catch (DateTimeException dte) {
            this.getLogger().debug("Failed to convert temporal accessor to LocalTime directly", (Throwable)dte);
            return (T)((TemporalAccessor)type.cast(Instant.from(value).atOffset(ZoneOffset.UTC).toLocalTime()));
        }
    }
}

