/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class LocaleConverter
extends AbstractConverter {
    public LocaleConverter() {
    }

    public LocaleConverter(Locale defaultValue) {
        super((Object)defaultValue);
    }

    @NotNull
    protected Class<?> getDefaultType() {
        return Locale.class;
    }

    protected <T> T convertToType(@NotNull Class<T> type, Object value) throws Throwable {
        if (type.isAssignableFrom(Locale.class)) {
            Locale result = Locale.forLanguageTag(value.toString());
            if (result.getLanguage().isEmpty()) {
                throw this.conversionException(type, value);
            }
            return type.cast(result);
        }
        throw this.conversionException(type, value);
    }

    protected String convertToString(Object value) throws Throwable {
        if (value instanceof Locale) {
            return ((Locale)value).toLanguageTag();
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw this.conversionException(String.class, value);
    }
}

