/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import dev.orne.beans.converters.InstantConverter;
import dev.orne.beans.converters.MonthDayConverter;
import dev.orne.beans.converters.YearMonthConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class MonthConverter
extends AbstractDateTimeConverter {
    public static final DateTimeFormatter BY_VALUE_PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.MONTH_OF_YEAR).toFormatter();
    public static final DateTimeFormatter BY_FULL_TEXT_PARSER = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.FULL_STANDALONE).toFormatter();
    public static final DateTimeFormatter BY_SHORT_TEXT_PARSER = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT_STANDALONE).toFormatter();
    public static final DateTimeFormatter BY_NARROW_TEXT_PARSER = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.NARROW_STANDALONE).toFormatter();

    public MonthConverter() {
        super(BY_VALUE_PARSER);
        this.setDefaultParsers();
    }

    public MonthConverter(Month defaultValue) {
        super(BY_VALUE_PARSER, defaultValue);
        this.setDefaultParsers();
    }

    public MonthConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public MonthConverter(@NotNull DateTimeFormatter formatter, Month defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(BY_VALUE_PARSER, BY_FULL_TEXT_PARSER, BY_SHORT_TEXT_PARSER, BY_NARROW_TEXT_PARSER, YearMonthConverter.ISO_8601_PARSER, YearMonthConverter.BY_FULL_TEXT_PARSER, YearMonthConverter.BY_SHORT_TEXT_PARSER, YearMonthConverter.BY_NARROW_TEXT_PARSER, MonthDayConverter.ISO_8601_PARSER, MonthDayConverter.BY_FULL_TEXT_PARSER, MonthDayConverter.BY_SHORT_TEXT_PARSER, MonthDayConverter.BY_NARROW_TEXT_PARSER, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.ISO_WEEK_DATE, DateTimeFormatter.BASIC_ISO_DATE, InstantConverter.EPOCH_MILLIS_PARSER);
    }

    @Override
    @NotNull
    protected Class<?> getDefaultType() {
        return Month.class;
    }

    @Override
    protected <T> T convertToType(@NotNull Class<T> type, Object value) {
        if (type.isAssignableFrom(Month.class)) {
            if (value instanceof String) {
                try {
                    return type.cast(Month.valueOf((String)value));
                }
                catch (IllegalArgumentException iae) {
                    this.getLogger().debug("Failed to parse value as constant name", (Throwable)iae);
                    return super.convertToType(type, value);
                }
            }
            if (value instanceof Number) {
                try {
                    return type.cast(Month.of(((Number)value).intValue()));
                }
                catch (DateTimeException dte) {
                    this.getLogger().debug("Failed to parse value as constant value", (Throwable)dte);
                    return super.convertToType(type, value);
                }
            }
            return super.convertToType(type, value);
        }
        throw this.conversionException(type, value);
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        try {
            return (T)((TemporalAccessor)type.cast(Month.from(value)));
        }
        catch (DateTimeException dte) {
            this.getLogger().debug("Failed to convert temporal accessor to DayOfWeek directly", (Throwable)dte);
            return (T)((TemporalAccessor)type.cast(Instant.from(value).atOffset(ZoneOffset.UTC).getMonth()));
        }
    }

    @Override
    protected String convertToString(Object value) {
        if (value instanceof Month) {
            return ((Month)value).name();
        }
        return super.convertToString(value);
    }
}

