/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import dev.orne.beans.converters.InstantConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.MonthDay;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class MonthDayConverter
extends AbstractDateTimeConverter {
    public static final DateTimeFormatter ISO_8601_PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    public static final DateTimeFormatter BY_FULL_TEXT_PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.FULL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    public static final DateTimeFormatter BY_SHORT_TEXT_PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    public static final DateTimeFormatter BY_NARROW_TEXT_PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.NARROW).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();

    public MonthDayConverter() {
        super(ISO_8601_PARSER);
        this.setDefaultParsers();
    }

    public MonthDayConverter(MonthDay defaultValue) {
        super(ISO_8601_PARSER, defaultValue);
        this.setDefaultParsers();
    }

    public MonthDayConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public MonthDayConverter(@NotNull DateTimeFormatter formatter, MonthDay defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(ISO_8601_PARSER, BY_FULL_TEXT_PARSER, BY_SHORT_TEXT_PARSER, BY_NARROW_TEXT_PARSER, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.ISO_WEEK_DATE, DateTimeFormatter.BASIC_ISO_DATE, InstantConverter.EPOCH_MILLIS_PARSER);
    }

    @Override
    @NotNull
    protected Class<?> getDefaultType() {
        return MonthDay.class;
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        try {
            return (T)((TemporalAccessor)type.cast(MonthDay.from(value)));
        }
        catch (DateTimeException dte) {
            this.getLogger().debug("Failed to convert temporal accessor to MonthDay directly", (Throwable)dte);
            return (T)((TemporalAccessor)type.cast(MonthDay.from(Instant.from(value).atOffset(ZoneOffset.UTC))));
        }
    }
}

