/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import dev.orne.beans.converters.InstantConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class OffsetTimeConverter
extends AbstractDateTimeConverter {
    public OffsetTimeConverter() {
        super(DateTimeFormatter.ISO_OFFSET_TIME);
        this.setDefaultParsers();
    }

    public OffsetTimeConverter(OffsetTime defaultValue) {
        super(DateTimeFormatter.ISO_OFFSET_TIME, defaultValue);
        this.setDefaultParsers();
    }

    public OffsetTimeConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public OffsetTimeConverter(@NotNull DateTimeFormatter formatter, OffsetTime defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_TIME, InstantConverter.EPOCH_MILLIS_PARSER);
    }

    @Override
    @NotNull
    protected Class<?> getDefaultType() {
        return OffsetTime.class;
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        try {
            return (T)((TemporalAccessor)type.cast(OffsetTime.from(value)));
        }
        catch (DateTimeException dte) {
            this.getLogger().debug("Failed to convert temporal accessor to OffsetTime directly", (Throwable)dte);
            try {
                return (T)((TemporalAccessor)type.cast(LocalTime.from(value).atOffset(ZoneOffset.UTC)));
            }
            catch (DateTimeException dte2) {
                this.getLogger().debug("Failed to convert temporal accessor to LocalTime directly", (Throwable)dte2);
                return (T)((TemporalAccessor)type.cast(Instant.from(value).atOffset(ZoneOffset.UTC).toOffsetTime()));
            }
        }
    }
}

