/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.Identity;
import dev.orne.beans.converters.DateConverter;
import dev.orne.beans.converters.DayOfWeekConverter;
import dev.orne.beans.converters.DurationConverter;
import dev.orne.beans.converters.EnumConverter;
import dev.orne.beans.converters.GregorianCalendarConverter;
import dev.orne.beans.converters.IdentityConverter;
import dev.orne.beans.converters.InstantConverter;
import dev.orne.beans.converters.LocalDateConverter;
import dev.orne.beans.converters.LocalDateTimeConverter;
import dev.orne.beans.converters.LocalTimeConverter;
import dev.orne.beans.converters.LocaleConverter;
import dev.orne.beans.converters.MonthConverter;
import dev.orne.beans.converters.MonthDayConverter;
import dev.orne.beans.converters.OffsetDateTimeConverter;
import dev.orne.beans.converters.OffsetTimeConverter;
import dev.orne.beans.converters.PeriodConverter;
import dev.orne.beans.converters.UriConverter;
import dev.orne.beans.converters.YearConverter;
import dev.orne.beans.converters.YearMonthConverter;
import dev.orne.beans.converters.ZoneOffsetConverter;
import dev.orne.beans.converters.ZonedDateTimeConverter;
import java.net.URI;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public final class OrneBeansConverters {
    private OrneBeansConverters() {
    }

    public static void register() {
        OrneBeansConverters.registerBeansConversors();
        OrneBeansConverters.registerNetConversors();
        OrneBeansConverters.registerUtilConversors();
        OrneBeansConverters.registerTimeConversors();
    }

    public static void register(boolean defaultToNull) {
        OrneBeansConverters.registerBeansConversors(defaultToNull);
        OrneBeansConverters.registerNetConversors(defaultToNull);
        OrneBeansConverters.registerUtilConversors(defaultToNull);
        OrneBeansConverters.registerTimeConversors(defaultToNull);
    }

    public static void register(@NotNull ConvertUtilsBean converter) {
        OrneBeansConverters.registerBeansConversors(converter);
        OrneBeansConverters.registerNetConversors(converter);
        OrneBeansConverters.registerUtilConversors(converter);
        OrneBeansConverters.registerTimeConversors(converter);
    }

    public static void register(@NotNull ConvertUtilsBean converter, boolean defaultToNull) {
        OrneBeansConverters.registerBeansConversors(converter, defaultToNull);
        OrneBeansConverters.registerNetConversors(converter, defaultToNull);
        OrneBeansConverters.registerUtilConversors(converter, defaultToNull);
        OrneBeansConverters.registerTimeConversors(converter, defaultToNull);
    }

    public static void registerBeansConversors() {
        OrneBeansConverters.registerBeansConversors(false);
    }

    public static void registerBeansConversors(boolean defaultToNull) {
        if (defaultToNull) {
            ConvertUtils.register((Converter)new IdentityConverter(null), Identity.class);
        } else {
            ConvertUtils.register((Converter)new IdentityConverter(), Identity.class);
        }
    }

    public static void registerBeansConversors(@NotNull ConvertUtilsBean converter) {
        OrneBeansConverters.registerBeansConversors(converter, false);
    }

    public static void registerBeansConversors(@NotNull ConvertUtilsBean converter, boolean defaultToNull) {
        if (defaultToNull) {
            converter.register((Converter)new IdentityConverter(null), Identity.class);
            converter.register((Converter)EnumConverter.GENERIC_DEFAULT, Enum.class);
        } else {
            converter.register((Converter)new IdentityConverter(), Identity.class);
            converter.register((Converter)EnumConverter.GENERIC, Enum.class);
        }
    }

    public static void registerNetConversors() {
        OrneBeansConverters.registerNetConversors(false);
    }

    public static void registerNetConversors(boolean defaultToNull) {
        if (defaultToNull) {
            ConvertUtils.register((Converter)new UriConverter(null), URI.class);
        } else {
            ConvertUtils.register((Converter)new UriConverter(), URI.class);
        }
    }

    public static void registerNetConversors(@NotNull ConvertUtilsBean converter) {
        OrneBeansConverters.registerNetConversors(converter, false);
    }

    public static void registerNetConversors(@NotNull ConvertUtilsBean converter, boolean defaultToNull) {
        if (defaultToNull) {
            converter.register((Converter)new UriConverter(null), URI.class);
        } else {
            converter.register((Converter)new UriConverter(), URI.class);
        }
    }

    public static void registerUtilConversors() {
        OrneBeansConverters.registerUtilConversors(false);
    }

    public static void registerUtilConversors(boolean defaultToNull) {
        if (defaultToNull) {
            ConvertUtils.register((Converter)new GregorianCalendarConverter((GregorianCalendar)null), GregorianCalendar.class);
            ConvertUtils.register((Converter)new GregorianCalendarConverter((GregorianCalendar)null), Calendar.class);
            ConvertUtils.register((Converter)new DateConverter((Date)null), Date.class);
            ConvertUtils.register((Converter)new LocaleConverter(null), Locale.class);
        } else {
            ConvertUtils.register((Converter)new GregorianCalendarConverter(), GregorianCalendar.class);
            ConvertUtils.register((Converter)new GregorianCalendarConverter(), Calendar.class);
            ConvertUtils.register((Converter)new DateConverter(), Date.class);
            ConvertUtils.register((Converter)new LocaleConverter(), Locale.class);
        }
    }

    public static void registerUtilConversors(@NotNull ConvertUtilsBean converter) {
        OrneBeansConverters.registerUtilConversors(converter, false);
    }

    public static void registerUtilConversors(@NotNull ConvertUtilsBean converter, boolean defaultToNull) {
        if (defaultToNull) {
            converter.register((Converter)new GregorianCalendarConverter((GregorianCalendar)null), GregorianCalendar.class);
            converter.register((Converter)new GregorianCalendarConverter((GregorianCalendar)null), Calendar.class);
            converter.register((Converter)new DateConverter((Date)null), Date.class);
            converter.register((Converter)new LocaleConverter(null), Locale.class);
        } else {
            converter.register((Converter)new GregorianCalendarConverter(), GregorianCalendar.class);
            converter.register((Converter)new GregorianCalendarConverter(), Calendar.class);
            converter.register((Converter)new DateConverter(), Date.class);
            converter.register((Converter)new LocaleConverter(), Locale.class);
        }
    }

    public static void registerTimeConversors() {
        OrneBeansConverters.registerTimeConversors(false);
    }

    public static void registerTimeConversors(boolean defaultToNull) {
        if (defaultToNull) {
            ConvertUtils.register((Converter)new InstantConverter((Instant)null), Instant.class);
            ConvertUtils.register((Converter)new YearConverter((Year)null), Year.class);
            ConvertUtils.register((Converter)new YearMonthConverter((YearMonth)null), YearMonth.class);
            ConvertUtils.register((Converter)new MonthConverter((Month)null), Month.class);
            ConvertUtils.register((Converter)new MonthDayConverter((MonthDay)null), MonthDay.class);
            ConvertUtils.register((Converter)new DayOfWeekConverter((DayOfWeek)null), DayOfWeek.class);
            ConvertUtils.register((Converter)new LocalDateConverter((LocalDate)null), LocalDate.class);
            ConvertUtils.register((Converter)new LocalTimeConverter((LocalTime)null), LocalTime.class);
            ConvertUtils.register((Converter)new LocalDateTimeConverter((LocalDateTime)null), LocalDateTime.class);
            ConvertUtils.register((Converter)new OffsetTimeConverter((OffsetTime)null), OffsetTime.class);
            ConvertUtils.register((Converter)new OffsetDateTimeConverter((OffsetDateTime)null), OffsetDateTime.class);
            ConvertUtils.register((Converter)new ZonedDateTimeConverter((ZonedDateTime)null), ZonedDateTime.class);
            ConvertUtils.register((Converter)new ZoneOffsetConverter((ZoneOffset)null), ZoneId.class);
            ConvertUtils.register((Converter)new ZoneOffsetConverter((ZoneOffset)null), ZoneOffset.class);
            ConvertUtils.register((Converter)new DurationConverter(null), Duration.class);
            ConvertUtils.register((Converter)new PeriodConverter(null), Period.class);
        } else {
            ConvertUtils.register((Converter)new InstantConverter(), Instant.class);
            ConvertUtils.register((Converter)new YearConverter(), Year.class);
            ConvertUtils.register((Converter)new YearMonthConverter(), YearMonth.class);
            ConvertUtils.register((Converter)new MonthConverter(), Month.class);
            ConvertUtils.register((Converter)new MonthDayConverter(), MonthDay.class);
            ConvertUtils.register((Converter)new DayOfWeekConverter(), DayOfWeek.class);
            ConvertUtils.register((Converter)new LocalDateConverter(), LocalDate.class);
            ConvertUtils.register((Converter)new LocalTimeConverter(), LocalTime.class);
            ConvertUtils.register((Converter)new LocalDateTimeConverter(), LocalDateTime.class);
            ConvertUtils.register((Converter)new OffsetTimeConverter(), OffsetTime.class);
            ConvertUtils.register((Converter)new OffsetDateTimeConverter(), OffsetDateTime.class);
            ConvertUtils.register((Converter)new ZonedDateTimeConverter(), ZonedDateTime.class);
            ConvertUtils.register((Converter)new ZoneOffsetConverter(), ZoneId.class);
            ConvertUtils.register((Converter)new ZoneOffsetConverter(), ZoneOffset.class);
            ConvertUtils.register((Converter)new DurationConverter(), Duration.class);
            ConvertUtils.register((Converter)new PeriodConverter(), Period.class);
        }
    }

    public static void registerTimeConversors(@NotNull ConvertUtilsBean converter) {
        OrneBeansConverters.registerTimeConversors(converter, false);
    }

    public static void registerTimeConversors(@NotNull ConvertUtilsBean converter, boolean defaultToNull) {
        if (defaultToNull) {
            converter.register((Converter)new InstantConverter((Instant)null), Instant.class);
            converter.register((Converter)new YearConverter((Year)null), Year.class);
            converter.register((Converter)new YearMonthConverter((YearMonth)null), YearMonth.class);
            converter.register((Converter)new MonthConverter((Month)null), Month.class);
            converter.register((Converter)new MonthDayConverter((MonthDay)null), MonthDay.class);
            converter.register((Converter)new DayOfWeekConverter((DayOfWeek)null), DayOfWeek.class);
            converter.register((Converter)new LocalDateConverter((LocalDate)null), LocalDate.class);
            converter.register((Converter)new LocalTimeConverter((LocalTime)null), LocalTime.class);
            converter.register((Converter)new LocalDateTimeConverter((LocalDateTime)null), LocalDateTime.class);
            converter.register((Converter)new OffsetTimeConverter((OffsetTime)null), OffsetTime.class);
            converter.register((Converter)new OffsetDateTimeConverter((OffsetDateTime)null), OffsetDateTime.class);
            converter.register((Converter)new ZonedDateTimeConverter((ZonedDateTime)null), ZonedDateTime.class);
            converter.register((Converter)new ZoneOffsetConverter((ZoneOffset)null), ZoneId.class);
            converter.register((Converter)new ZoneOffsetConverter((ZoneOffset)null), ZoneOffset.class);
            converter.register((Converter)new DurationConverter(null), Duration.class);
            converter.register((Converter)new PeriodConverter(null), Period.class);
        } else {
            converter.register((Converter)new InstantConverter(), Instant.class);
            converter.register((Converter)new YearConverter(), Year.class);
            converter.register((Converter)new YearMonthConverter(), YearMonth.class);
            converter.register((Converter)new MonthConverter(), Month.class);
            converter.register((Converter)new MonthDayConverter(), MonthDay.class);
            converter.register((Converter)new DayOfWeekConverter(), DayOfWeek.class);
            converter.register((Converter)new LocalDateConverter(), LocalDate.class);
            converter.register((Converter)new LocalTimeConverter(), LocalTime.class);
            converter.register((Converter)new LocalDateTimeConverter(), LocalDateTime.class);
            converter.register((Converter)new OffsetTimeConverter(), OffsetTime.class);
            converter.register((Converter)new OffsetDateTimeConverter(), OffsetDateTime.class);
            converter.register((Converter)new ZonedDateTimeConverter(), ZonedDateTime.class);
            converter.register((Converter)new ZoneOffsetConverter(), ZoneId.class);
            converter.register((Converter)new ZoneOffsetConverter(), ZoneOffset.class);
            converter.register((Converter)new DurationConverter(), Duration.class);
            converter.register((Converter)new PeriodConverter(), Period.class);
        }
    }
}

