/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import dev.orne.beans.converters.InstantConverter;
import dev.orne.beans.converters.YearMonthConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class YearConverter
extends AbstractDateTimeConverter {
    public static final DateTimeFormatter BY_VALUE_PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter();

    public YearConverter() {
        super(BY_VALUE_PARSER);
        this.setDefaultParsers();
    }

    public YearConverter(Year defaultValue) {
        super(BY_VALUE_PARSER, defaultValue);
        this.setDefaultParsers();
    }

    public YearConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public YearConverter(@NotNull DateTimeFormatter formatter, Year defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(BY_VALUE_PARSER, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_DATE, YearMonthConverter.ISO_8601_PARSER, YearMonthConverter.BY_FULL_TEXT_PARSER, YearMonthConverter.BY_SHORT_TEXT_PARSER, YearMonthConverter.BY_NARROW_TEXT_PARSER, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.ISO_WEEK_DATE, DateTimeFormatter.BASIC_ISO_DATE, InstantConverter.EPOCH_MILLIS_PARSER);
    }

    @Override
    @NotNull
    protected Class<?> getDefaultType() {
        return Year.class;
    }

    @Override
    protected <T> T convertToType(@NotNull Class<T> type, Object value) {
        if (type.isAssignableFrom(Year.class)) {
            if (value instanceof Integer) {
                return type.cast(Year.of((Integer)value));
            }
            return super.convertToType(type, value);
        }
        throw this.conversionException(type, value);
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        try {
            return (T)((TemporalAccessor)type.cast(Year.from(value)));
        }
        catch (DateTimeException dte) {
            this.getLogger().debug("Failed to convert temporal accessor to Year directly", (Throwable)dte);
            return (T)((TemporalAccessor)type.cast(Year.from(Instant.from(value).atOffset(ZoneOffset.UTC))));
        }
    }
}

