/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class ZoneOffsetConverter
extends AbstractDateTimeConverter {
    public static final DateTimeFormatter BY_ID_PARSER = new DateTimeFormatterBuilder().appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();

    public ZoneOffsetConverter() {
        super(BY_ID_PARSER);
        this.setDefaultParsers();
    }

    public ZoneOffsetConverter(ZoneOffset defaultValue) {
        super(BY_ID_PARSER, defaultValue);
        this.setDefaultParsers();
    }

    public ZoneOffsetConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public ZoneOffsetConverter(@NotNull DateTimeFormatter formatter, ZoneOffset defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(BY_ID_PARSER, DateTimeFormatter.ISO_ZONED_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE, DateTimeFormatter.ISO_OFFSET_TIME);
    }

    @Override
    @NotNull
    protected Class<?> getDefaultType() {
        return ZoneOffset.class;
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        return (T)((TemporalAccessor)type.cast(ZoneOffset.from(value)));
    }
}

