/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.converters;

import dev.orne.beans.converters.AbstractDateTimeConverter;
import dev.orne.beans.converters.InstantConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import javax.validation.constraints.NotNull;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="0.1")
public class ZonedDateTimeConverter
extends AbstractDateTimeConverter {
    public ZonedDateTimeConverter() {
        super(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        this.setDefaultParsers();
    }

    public ZonedDateTimeConverter(ZonedDateTime defaultValue) {
        super(DateTimeFormatter.ISO_ZONED_DATE_TIME, defaultValue);
        this.setDefaultParsers();
    }

    public ZonedDateTimeConverter(@NotNull DateTimeFormatter formatter) {
        super(formatter);
        this.setDefaultParsers();
    }

    public ZonedDateTimeConverter(@NotNull DateTimeFormatter formatter, ZonedDateTime defaultValue) {
        super(formatter, defaultValue);
        this.setDefaultParsers();
    }

    private final void setDefaultParsers() {
        this.setParsers(DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_INSTANT, InstantConverter.EPOCH_MILLIS_PARSER);
    }

    @Override
    @NotNull
    protected Class<?> getDefaultType() {
        return ZonedDateTime.class;
    }

    @Override
    protected <T extends TemporalAccessor> T fromTemporalAccessor(@NotNull Class<T> type, @NotNull TemporalAccessor value) {
        try {
            return (T)((TemporalAccessor)type.cast(ZonedDateTime.from(value)));
        }
        catch (DateTimeException dte) {
            this.getLogger().debug("Failed to convert temporal accessor to ZonedDateTime directly", (Throwable)dte);
            try {
                return (T)((TemporalAccessor)type.cast(LocalDateTime.from(value).atZone(ZoneOffset.UTC)));
            }
            catch (DateTimeException dte2) {
                this.getLogger().debug("Failed to convert temporal accessor to LocalDateTime directly", (Throwable)dte2);
                return (T)((TemporalAccessor)type.cast(Instant.from(value).atZone(ZoneOffset.UTC)));
            }
        }
    }
}

