/*
 * Decompiled with CFR 0.152.
 */
package dev.orne.beans.rnd;

import dev.orne.beans.Identity;
import dev.orne.beans.IdentityTokenFormatter;
import dev.orne.beans.TokenIdentity;
import dev.orne.test.rnd.AbstractTypedGenerator;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="0.6")
public class TokenIdentityGenerator
extends AbstractTypedGenerator<TokenIdentity> {
    private static final String VALID_BODY_START_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String VALID_BODY_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";

    public boolean supports(@NotNull Class<?> type) {
        return super.supports(type) || Identity.class.equals(type);
    }

    @NotNull
    public TokenIdentity defaultValue() {
        return new TokenIdentity(IdentityTokenFormatter.format(null));
    }

    @NotNull
    public TokenIdentity randomValue() {
        String prefix = RandomStringUtils.randomAlphabetic((int)1, (int)10);
        String body = RandomUtils.nextFloat((float)0.0f, (float)1.0f) < 0.02f ? null : (RandomUtils.nextBoolean() ? RandomStringUtils.random((int)1, (String)VALID_BODY_START_CHARS) + RandomStringUtils.random((int)RandomUtils.nextInt((int)0, (int)20), (String)VALID_BODY_CHARS) : RandomStringUtils.random((int)RandomUtils.nextInt((int)1, (int)20)));
        return new TokenIdentity(IdentityTokenFormatter.format(prefix, body));
    }
}

