/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.security;

import com.redhat.parodos.config.properties.LdapConnectionProperties;
import com.redhat.parodos.config.properties.SecurityProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.stereotype.Component;

@Component
@Configuration
@Profile(value={"!local"})
@DependsOn(value={"org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor"})
public class SecurityConfiguration {
    @Autowired
    private LdapConnectionProperties ldapConnectionProperties;
    @Autowired
    private SecurityProperties securityProperties;

    public HttpSecurity setHttpSecurity(HttpSecurity http) throws Exception {
        http.csrf().csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse());
        if (!this.securityProperties.getAuthentication().booleanValue()) {
            return http;
        }
        ((HttpSecurity)((HttpSecurity)http.authorizeRequests().mvcMatchers(HttpMethod.OPTIONS, new String[]{"/**"}).permitAll().mvcMatchers(new String[]{"/api/**", "/actuator/shutdown"}).fullyAuthenticated().and()).httpBasic(Customizer.withDefaults()).headers().frameOptions().disable().and()).formLogin(form -> form.loginProcessingUrl("/login")).logout().logoutSuccessUrl("/login").permitAll();
        return http;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        HttpSecurity httpSec = this.setHttpSecurity(http);
        return (SecurityFilterChain)httpSec.build();
    }

    @Autowired
    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (!this.securityProperties.getAuthentication().booleanValue()) {
            return;
        }
        auth.ldapAuthentication().userDnPatterns(new String[]{this.ldapConnectionProperties.getUserDNPatterns()}).groupSearchBase(this.ldapConnectionProperties.getGroupSearchBase()).contextSource().url(this.ldapConnectionProperties.getUrl()).managerDn(this.ldapConnectionProperties.getManagerDN()).managerPassword(this.ldapConnectionProperties.getManagerPassword()).and().passwordCompare().passwordEncoder((PasswordEncoder)new BCryptPasswordEncoder()).passwordAttribute(this.ldapConnectionProperties.getPasswordAttribute());
    }
}

