/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.definition.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.redhat.parodos.common.AbstractEntity;
import com.redhat.parodos.workflow.definition.dto.WorkDefinitionResponseDTO;
import com.redhat.parodos.workflow.definition.dto.WorkFlowCheckerDTO;
import com.redhat.parodos.workflow.definition.dto.WorkFlowDefinitionResponseDTO;
import com.redhat.parodos.workflow.definition.entity.WorkFlowCheckerMappingDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowPropertiesDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowTaskDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowWorkDefinition;
import com.redhat.parodos.workflow.definition.repository.WorkFlowCheckerMappingDefinitionRepository;
import com.redhat.parodos.workflow.definition.repository.WorkFlowDefinitionRepository;
import com.redhat.parodos.workflow.definition.repository.WorkFlowTaskDefinitionRepository;
import com.redhat.parodos.workflow.definition.repository.WorkFlowWorkRepository;
import com.redhat.parodos.workflow.definition.service.WorkFlowDefinitionService;
import com.redhat.parodos.workflow.definition.service.WorkFlowDefinitionServiceImpl;
import com.redhat.parodos.workflow.enums.WorkFlowProcessingType;
import com.redhat.parodos.workflow.enums.WorkFlowType;
import com.redhat.parodos.workflow.enums.WorkType;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.task.WorkFlowTask;
import com.redhat.parodos.workflow.util.WorkFlowDTOUtil;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import com.redhat.parodos.workflows.workflow.WorkFlowPropertiesMetadata;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowDefinitionServiceImpl
implements WorkFlowDefinitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowDefinitionServiceImpl.class);
    private final WorkFlowDefinitionRepository workFlowDefinitionRepository;
    private final WorkFlowTaskDefinitionRepository workFlowTaskDefinitionRepository;
    private final WorkFlowCheckerMappingDefinitionRepository workFlowCheckerMappingDefinitionRepository;
    private final WorkFlowWorkRepository workFlowWorkRepository;
    private final ModelMapper modelMapper;

    public WorkFlowDefinitionServiceImpl(WorkFlowDefinitionRepository workFlowDefinitionRepository, WorkFlowTaskDefinitionRepository workFlowTaskDefinitionRepository, WorkFlowCheckerMappingDefinitionRepository workFlowCheckerMappingDefinitionRepository, WorkFlowWorkRepository workFlowWorkRepository, ModelMapper modelMapper) {
        this.workFlowDefinitionRepository = workFlowDefinitionRepository;
        this.workFlowTaskDefinitionRepository = workFlowTaskDefinitionRepository;
        this.workFlowCheckerMappingDefinitionRepository = workFlowCheckerMappingDefinitionRepository;
        this.workFlowWorkRepository = workFlowWorkRepository;
        this.modelMapper = modelMapper;
    }

    private HashMap<String, Map<String, Object>> convertWorkParameters(List<WorkParameter> workParameters) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (WorkParameter workParameter : workParameters) {
            if (workParameter == null) continue;
            result.put(workParameter.getKey(), workParameter.getAsJsonSchema());
        }
        return result;
    }

    public WorkFlowDefinitionResponseDTO save(String workFlowName, WorkFlowType workFlowType, WorkFlowPropertiesMetadata properties, List<WorkParameter> workParameters, List<Work> works, WorkFlowProcessingType workFlowProcessingType) {
        WorkFlowDefinition workFlowDefinition;
        String stringifyParameters = WorkFlowDTOUtil.writeObjectValueAsString((Object)this.convertWorkParameters(workParameters));
        WorkFlowPropertiesDefinition propertiesDefinition = WorkFlowPropertiesDefinition.builder().build();
        if (properties != null) {
            propertiesDefinition.setVersion(properties.getVersion());
        }
        if ((workFlowDefinition = this.workFlowDefinitionRepository.findFirstByName(workFlowName)) == null) {
            workFlowDefinition = WorkFlowDefinition.builder().name(workFlowName).createDate(new Date()).build();
        }
        workFlowDefinition.setType(workFlowType);
        workFlowDefinition.setParameters(stringifyParameters);
        workFlowDefinition.setModifyDate(new Date());
        workFlowDefinition.setProperties(propertiesDefinition);
        workFlowDefinition.setProcessingType(workFlowProcessingType);
        workFlowDefinition.setNumberOfWorks(Integer.valueOf(works.size()));
        workFlowDefinition = (WorkFlowDefinition)this.workFlowDefinitionRepository.save((Object)workFlowDefinition);
        ArrayList workFlowWorkDefinitions = new ArrayList();
        WorkFlowDefinition finalWorkFlowDefinition = workFlowDefinition;
        works.forEach(work -> {
            UUID workId = null;
            if (work instanceof WorkFlow) {
                workId = this.workFlowDefinitionRepository.findFirstByName(work.getName()).getId();
                workFlowWorkDefinitions.add(WorkFlowWorkDefinition.builder().workDefinitionId(workId).workDefinitionType(WorkType.WORKFLOW).workFlowDefinition(finalWorkFlowDefinition).createDate(new Date()).build());
            } else {
                WorkFlowTask workFlowTask = (WorkFlowTask)work;
                String taskParameters = WorkFlowDTOUtil.writeObjectValueAsString((Object)workFlowTask.getAsJsonSchema());
                String taskOutputs = WorkFlowDTOUtil.writeObjectValueAsString((Object)workFlowTask.getWorkFlowTaskOutputs());
                Optional<WorkFlowTaskDefinition> workFlowTaskDefinitionOptional = Optional.ofNullable(this.workFlowTaskDefinitionRepository.findFirstByName(workFlowTask.getName()));
                if (workFlowTaskDefinitionOptional.filter(workFlowTaskDefinitionItem -> finalWorkFlowDefinition.getName().equals(workFlowTaskDefinitionItem.getWorkFlowDefinition().getName()) && taskParameters.equals(workFlowTaskDefinitionItem.getParameters()) && taskOutputs.equals(workFlowTaskDefinitionItem.getOutputs())).isEmpty()) {
                    workId = ((WorkFlowTaskDefinition)this.workFlowTaskDefinitionRepository.save((Object)workFlowTaskDefinitionOptional.map(foundWorkflowTaskDefinition -> {
                        foundWorkflowTaskDefinition.setParameters(taskParameters);
                        foundWorkflowTaskDefinition.setModifyDate(new Date());
                        foundWorkflowTaskDefinition.setOutputs(taskOutputs);
                        foundWorkflowTaskDefinition.setWorkFlowDefinition(finalWorkFlowDefinition);
                        return foundWorkflowTaskDefinition;
                    }).orElse(WorkFlowTaskDefinition.builder().name(workFlowTask.getName()).parameters(WorkFlowDTOUtil.writeObjectValueAsString((Object)workFlowTask.getAsJsonSchema())).outputs(WorkFlowDTOUtil.writeObjectValueAsString((Object)workFlowTask.getWorkFlowTaskOutputs())).workFlowDefinition(finalWorkFlowDefinition).createDate(new Date()).modifyDate(new Date()).build()))).getId();
                }
                workFlowWorkDefinitions.add(WorkFlowWorkDefinition.builder().workDefinitionId(workFlowTaskDefinitionOptional.map(AbstractEntity::getId).orElse(workId)).workDefinitionType(WorkType.TASK).workFlowDefinition(finalWorkFlowDefinition).createDate(new Date()).build());
            }
        });
        workFlowDefinition.setWorkFlowWorkDefinitions(workFlowWorkDefinitions);
        return (WorkFlowDefinitionResponseDTO)this.modelMapper.map(this.workFlowDefinitionRepository.save((Object)workFlowDefinition), WorkFlowDefinitionResponseDTO.class);
    }

    public List<WorkFlowDefinitionResponseDTO> getWorkFlowDefinitions() {
        ArrayList<WorkFlowDefinitionResponseDTO> workFlowDefinitionResponseDTOs = new ArrayList<WorkFlowDefinitionResponseDTO>();
        this.workFlowDefinitionRepository.findByTypeIsNot(WorkFlowType.CHECKER).forEach(workFlowDefinition -> workFlowDefinitionResponseDTOs.add(WorkFlowDefinitionResponseDTO.fromEntity((WorkFlowDefinition)workFlowDefinition, (List)this.buildWorkFlowWorksDTOs(workFlowDefinition, this.workFlowWorkRepository.findByWorkFlowDefinitionIdOrderByCreateDateAsc(workFlowDefinition.getId())))));
        return workFlowDefinitionResponseDTOs;
    }

    public WorkFlowDefinitionResponseDTO getWorkFlowDefinitionById(UUID id) {
        WorkFlowDefinition workFlowDefinition = (WorkFlowDefinition)this.workFlowDefinitionRepository.findById((Object)id).orElseThrow(() -> new RuntimeException(String.format("Workflow definition id %s not found", id)));
        List<WorkFlowWorkDefinition> workFlowWorkDependencies = this.workFlowWorkRepository.findByWorkFlowDefinitionIdOrderByCreateDateAsc(workFlowDefinition.getId()).stream().sorted(Comparator.comparing(WorkFlowWorkDefinition::getCreateDate)).toList();
        return WorkFlowDefinitionResponseDTO.fromEntity((WorkFlowDefinition)workFlowDefinition, (List)this.buildWorkFlowWorksDTOs(workFlowDefinition, workFlowWorkDependencies));
    }

    public WorkFlowDefinitionResponseDTO getWorkFlowDefinitionByName(String name) {
        WorkFlowDefinition workFlowDefinition = this.workFlowDefinitionRepository.findFirstByName(name);
        if (null == workFlowDefinition) {
            throw new RuntimeException(String.format("Workflow definition name %s not found", name));
        }
        List<WorkFlowWorkDefinition> workFlowWorkDependencies = this.workFlowWorkRepository.findByWorkFlowDefinitionIdOrderByCreateDateAsc(workFlowDefinition.getId()).stream().sorted(Comparator.comparing(WorkFlowWorkDefinition::getCreateDate)).toList();
        return WorkFlowDefinitionResponseDTO.fromEntity((WorkFlowDefinition)workFlowDefinition, (List)this.buildWorkFlowWorksDTOs(workFlowDefinition, workFlowWorkDependencies));
    }

    public void saveWorkFlowChecker(String workFlowTaskName, String workFlowCheckerName, WorkFlowCheckerDTO workFlowCheckerDTO) {
        try {
            WorkFlowTaskDefinition workFlowTaskDefinitionEntity = this.workFlowTaskDefinitionRepository.findFirstByName(workFlowTaskName);
            WorkFlowDefinition checkerWorkFlowDefinitionEntity = this.workFlowDefinitionRepository.findFirstByName(workFlowCheckerName);
            WorkFlowCheckerMappingDefinition workFlowCheckerMappingDefinition = Optional.ofNullable(this.workFlowCheckerMappingDefinitionRepository.findFirstByCheckWorkFlow(checkerWorkFlowDefinitionEntity)).orElse(WorkFlowCheckerMappingDefinition.builder().checkWorkFlow(checkerWorkFlowDefinitionEntity).cronExpression(workFlowCheckerDTO.getCronExpression()).tasks(new ArrayList()).build());
            workFlowTaskDefinitionEntity.setWorkFlowCheckerMappingDefinition(workFlowCheckerMappingDefinition);
            this.workFlowTaskDefinitionRepository.save((Object)workFlowTaskDefinitionEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public Map<String, Object> getWorkParametersByWorkName(String workName) {
        return Optional.ofNullable(this.workFlowTaskDefinitionRepository.findFirstByName(workName)).map(WorkFlowTaskDefinition::getParameters).map(stringifyParameters -> (Map)WorkFlowDTOUtil.readStringAsObject((String)stringifyParameters, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, null)).orElse(Optional.ofNullable(this.workFlowDefinitionRepository.findFirstByName(workName)).map(WorkFlowDefinition::getParameters).map(stringifyParameters -> (Map)WorkFlowDTOUtil.readStringAsObject((String)stringifyParameters, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, null)).orElse(null));
    }

    public WorkFlowDefinition getParentWorkFlowByWorkName(String workName) {
        UUID workId = Optional.ofNullable(this.workFlowDefinitionRepository.findFirstByName(workName)).map(AbstractEntity::getId).orElse(Optional.ofNullable(this.workFlowTaskDefinitionRepository.findFirstByName(workName)).map(AbstractEntity::getId).orElse(null));
        return workId == null ? null : (WorkFlowDefinition)Optional.ofNullable(this.workFlowWorkRepository.findFirstByWorkDefinitionId(workId)).map(WorkFlowWorkDefinition::getWorkFlowDefinition).orElse(null);
    }

    private void getWorksFromWorkDefinition(List<WorkFlowWorkDefinition> workFlowWorkDefinitions, CopyOnWriteArrayList<WorkDefinitionResponseDTO> responseDTOs) {
        workFlowWorkDefinitions.forEach(workFlowWorkDefinition -> {
            WorkType workType = workFlowWorkDefinition.getWorkDefinitionType();
            if (workType == null) {
                return;
            }
            switch (3.$SwitchMap$com$redhat$parodos$workflow$enums$WorkType[workType.ordinal()]) {
                case 1: {
                    Optional wdt = this.workFlowTaskDefinitionRepository.findById((Object)workFlowWorkDefinition.getWorkDefinitionId());
                    if (wdt.isEmpty()) {
                        log.error("Cannot find the task definition with id " + workFlowWorkDefinition.getWorkDefinitionId());
                        return;
                    }
                    responseDTOs.add(WorkDefinitionResponseDTO.fromWorkFlowTaskDefinition((WorkFlowTaskDefinition)((WorkFlowTaskDefinition)wdt.get())));
                    break;
                }
                case 2: {
                    Optional wd = this.workFlowDefinitionRepository.findById((Object)workFlowWorkDefinition.getWorkDefinitionId());
                    if (wd.isEmpty()) {
                        log.error("Cannot find work flow definition with id {}", (Object)workFlowWorkDefinition.getWorkDefinitionId());
                        return;
                    }
                    List wdWorkFlowWorkDependencies = this.workFlowWorkRepository.findByWorkFlowDefinitionIdOrderByCreateDateAsc(((WorkFlowDefinition)wd.get()).getId());
                    responseDTOs.add(WorkDefinitionResponseDTO.fromWorkFlowDefinitionEntity((WorkFlowDefinition)((WorkFlowDefinition)wd.get()), (List)wdWorkFlowWorkDependencies));
                    break;
                }
            }
        });
    }

    private List<WorkDefinitionResponseDTO> buildWorkFlowWorksDTOs(WorkFlowDefinition workFlowDefinition, List<WorkFlowWorkDefinition> workFlowWorkDefinitions) {
        CopyOnWriteArrayList<WorkDefinitionResponseDTO> workDefinitionResponseDTOs = new CopyOnWriteArrayList<WorkDefinitionResponseDTO>();
        HashMap<String, Integer> workFlowWorksStartIndex = new HashMap<String, Integer>();
        workDefinitionResponseDTOs.add(WorkDefinitionResponseDTO.builder().id(workFlowDefinition.getId()).workType(WorkType.WORKFLOW.name()).name(workFlowDefinition.getName()).parameterFromString(workFlowDefinition.getParameters()).processingType(workFlowDefinition.getProcessingType()).works(new ArrayList()).numberOfWorkUnits(Integer.valueOf(workFlowWorkDefinitions.size())).build());
        workFlowWorksStartIndex.put(workFlowDefinition.getName(), 1);
        this.getWorksFromWorkDefinition(workFlowWorkDefinitions, workDefinitionResponseDTOs);
        for (int i = 1; i < workDefinitionResponseDTOs.size(); ++i) {
            if (!((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(i)).getWorkType().equalsIgnoreCase(WorkType.WORKFLOW.name())) continue;
            workFlowWorksStartIndex.put(((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(i)).getName(), workDefinitionResponseDTOs.size());
            List<WorkFlowWorkDefinition> workFlowWorkUnits1Definition = this.workFlowWorkRepository.findByWorkFlowDefinitionIdOrderByCreateDateAsc(((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(i)).getId()).stream().sorted(Comparator.comparing(WorkFlowWorkDefinition::getCreateDate)).toList();
            this.getWorksFromWorkDefinition(workFlowWorkUnits1Definition, workDefinitionResponseDTOs);
        }
        for (int j = workDefinitionResponseDTOs.size() - 1; j >= 0; --j) {
            if (!((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(j)).getWorkType().equalsIgnoreCase(WorkType.WORKFLOW.name())) continue;
            ArrayList<WorkDefinitionResponseDTO> tmpList = new ArrayList<WorkDefinitionResponseDTO>();
            for (int k = ((Integer)workFlowWorksStartIndex.get(((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(j)).getName())).intValue(); k < (Integer)workFlowWorksStartIndex.get(((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(j)).getName()) + ((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(j)).getNumberOfWorkUnits() && k < workDefinitionResponseDTOs.size(); ++k) {
                tmpList.add((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(k));
            }
            ((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(j)).setWorks(tmpList);
        }
        return ((WorkDefinitionResponseDTO)workDefinitionResponseDTOs.get(0)).getWorks();
    }

    public void cleanAllDefinitionMappings() {
        this.workFlowCheckerMappingDefinitionRepository.deleteAll();
        this.workFlowWorkRepository.deleteAll();
    }
}

