/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.aspect;

import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.definition.entity.WorkFlowCheckerMappingDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowDefinition;
import com.redhat.parodos.workflow.enums.WorkFlowStatus;
import com.redhat.parodos.workflow.execution.aspect.WorkFlowPostInterceptor;
import com.redhat.parodos.workflow.execution.continuation.WorkFlowContinuationServiceImpl;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import com.redhat.parodos.workflow.execution.scheduler.WorkFlowSchedulerServiceImpl;
import com.redhat.parodos.workflow.execution.service.WorkFlowServiceImpl;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckerWorkFlowPostInterceptor
implements WorkFlowPostInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckerWorkFlowPostInterceptor.class);
    private final WorkFlowDefinition workFlowDefinition;
    private final WorkContext workContext;
    private final WorkFlowExecution workFlowExecution;
    private final WorkFlowExecution mainWorkFlowExecution;
    private final WorkFlowServiceImpl workFlowService;
    private final WorkFlowSchedulerServiceImpl workFlowSchedulerService;
    private final WorkFlowContinuationServiceImpl workFlowContinuationServiceImpl;
    private final WorkFlow workFlow;
    private final WorkStatus workStatus;

    public CheckerWorkFlowPostInterceptor(WorkFlowDefinition workFlowDefinition, WorkContext workContext, WorkFlowServiceImpl workFlowService, WorkFlowSchedulerServiceImpl workFlowSchedulerService, WorkFlowContinuationServiceImpl workFlowContinuationServiceImpl, WorkFlowExecution workFlowExecution, WorkFlowExecution mainWorkFlowExecution, WorkFlow workFlow, WorkStatus workStatus) {
        this.workFlowDefinition = workFlowDefinition;
        this.workContext = workContext;
        this.workFlowService = workFlowService;
        this.workFlowExecution = workFlowExecution;
        this.mainWorkFlowExecution = mainWorkFlowExecution;
        this.workFlowSchedulerService = workFlowSchedulerService;
        this.workFlowContinuationServiceImpl = workFlowContinuationServiceImpl;
        this.workFlow = workFlow;
        this.workStatus = workStatus;
    }

    public WorkReport handlePostWorkFlowExecution() {
        this.workFlowService.updateWorkFlow(this.workFlowExecution);
        this.startOrStopWorkFlowCheckerOnSchedule(this.workFlow, this.workFlowDefinition.getCheckerWorkFlowDefinition(), this.workStatus, this.workContext, this.workFlowExecution.getProjectId(), this.mainWorkFlowExecution);
        return null;
    }

    private void startOrStopWorkFlowCheckerOnSchedule(WorkFlow workFlow, WorkFlowCheckerMappingDefinition workFlowCheckerMappingDefinition, WorkStatus workStatus, WorkContext workContext, UUID projectId, WorkFlowExecution mainWorkFlowExecution) {
        if (workStatus != WorkStatus.COMPLETED) {
            if (workStatus != WorkStatus.REJECTED) {
                log.info("Schedule workflow checker: {} to run per cron expression: {}", (Object)workFlow.getName(), (Object)workFlowCheckerMappingDefinition.getCronExpression());
                this.workFlowSchedulerService.schedule(projectId, workFlow, workContext, workFlowCheckerMappingDefinition.getCronExpression());
            } else {
                log.info("Stop rejected workflow checker: {} schedule", (Object)workFlow.getName());
                this.workFlowSchedulerService.stop(projectId, workFlow);
                mainWorkFlowExecution.setStatus(WorkFlowStatus.FAILED);
                this.workFlowService.updateWorkFlow(mainWorkFlowExecution);
            }
            return;
        }
        log.info("Stop workflow checker: {} schedule", (Object)workFlow.getName());
        this.workFlowSchedulerService.stop(projectId, workFlow);
        String mainWorkFlowName = WorkContextDelegate.read((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_DEFINITION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.NAME).toString();
        if (this.workFlowService.findRunningChecker(mainWorkFlowExecution).isEmpty()) {
            this.workFlowContinuationServiceImpl.continueWorkFlow(projectId, mainWorkFlowName, workContext, mainWorkFlowExecution.getId());
        }
    }
}

