/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.aspect;

import com.redhat.parodos.workflow.annotation.WorkFlowProperties;
import com.redhat.parodos.workflow.version.WorkFlowVersionServiceImpl;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import com.redhat.parodos.workflows.workflow.WorkFlowPropertiesMetadata;
import java.io.IOException;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=-1)
public class WorkFlowPropertiesAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowPropertiesAspect.class);
    @Autowired
    public Environment env;

    @Around(value="@annotation(com.redhat.parodos.workflow.annotation.WorkFlowProperties) && args(..)")
    public Object WorkFlowPropertiesAround(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        WorkFlowProperties properties = signature.getMethod().getAnnotation(WorkFlowProperties.class);
        Object result = joinPoint.proceed();
        if (!(result instanceof WorkFlow)) {
            return result;
        }
        WorkFlow workFlow = (WorkFlow)result;
        return this.setPropertiesForWorkflow(workFlow, properties);
    }

    public Object setPropertiesForWorkflow(WorkFlow workFlow, WorkFlowProperties properties) throws IOException {
        if (properties == null) {
            return workFlow;
        }
        String version = this.env.resolvePlaceholders(properties.version());
        if (version.isEmpty()) {
            version = WorkFlowVersionServiceImpl.GetVersionHashForObject((Object)workFlow);
        }
        WorkFlowPropertiesMetadata propertiesMetadata = WorkFlowPropertiesMetadata.builder().version(version).build();
        workFlow.setProperties(propertiesMetadata);
        return workFlow;
    }
}

