/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.service;

import com.redhat.parodos.workflow.definition.entity.WorkFlowDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowTaskDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowWorkDefinition;
import com.redhat.parodos.workflow.definition.repository.WorkFlowDefinitionRepository;
import com.redhat.parodos.workflow.definition.repository.WorkFlowTaskDefinitionRepository;
import com.redhat.parodos.workflow.definition.repository.WorkFlowWorkRepository;
import com.redhat.parodos.workflow.enums.ParodosWorkStatus;
import com.redhat.parodos.workflow.enums.WorkFlowStatus;
import com.redhat.parodos.workflow.enums.WorkType;
import com.redhat.parodos.workflow.execution.dto.WorkStatusResponseDTO;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import com.redhat.parodos.workflow.execution.entity.WorkFlowTaskExecution;
import com.redhat.parodos.workflow.execution.repository.WorkFlowRepository;
import com.redhat.parodos.workflow.execution.repository.WorkFlowTaskRepository;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowServiceDelegate {
    private final WorkFlowDefinitionRepository workFlowDefinitionRepository;
    private final WorkFlowTaskDefinitionRepository workFlowTaskDefinitionRepository;
    private final WorkFlowRepository workFlowRepository;
    private final WorkFlowTaskRepository workFlowTaskRepository;
    private final WorkFlowWorkRepository workFlowWorkRepository;

    public WorkFlowServiceDelegate(WorkFlowDefinitionRepository workFlowDefinitionRepository, WorkFlowTaskDefinitionRepository workFlowTaskDefinitionRepository, WorkFlowRepository workFlowRepository, WorkFlowTaskRepository workFlowTaskRepository, WorkFlowWorkRepository workFlowWorkRepository) {
        this.workFlowDefinitionRepository = workFlowDefinitionRepository;
        this.workFlowTaskDefinitionRepository = workFlowTaskDefinitionRepository;
        this.workFlowRepository = workFlowRepository;
        this.workFlowTaskRepository = workFlowTaskRepository;
        this.workFlowWorkRepository = workFlowWorkRepository;
    }

    public List<WorkStatusResponseDTO> getWorkFlowAndWorksStatus(WorkFlowExecution workFlowExecution, WorkFlowDefinition workFlowDefinition) {
        CopyOnWriteArrayList workStatusResponseDTOs = new CopyOnWriteArrayList();
        HashMap workFlowWorkStartIndexMap = new HashMap();
        this.buildWorkFlowStatusDTO(workFlowExecution, workFlowDefinition, workStatusResponseDTOs, workFlowWorkStartIndexMap);
        for (int i = 1; i < workStatusResponseDTOs.size(); ++i) {
            if (!((WorkStatusResponseDTO)workStatusResponseDTOs.get(i)).getType().equals((Object)WorkType.WORKFLOW) || ((WorkStatusResponseDTO)workStatusResponseDTOs.get(i)).getWorkExecution() == null) continue;
            this.buildWorkFlowWorksStatusDTO(((WorkStatusResponseDTO)workStatusResponseDTOs.get(i)).getName(), ((WorkStatusResponseDTO)workStatusResponseDTOs.get(i)).getWorkExecution(), workFlowExecution, workStatusResponseDTOs, workFlowWorkStartIndexMap);
        }
        return this.nestWorkFlowWorksStatusDTO(workStatusResponseDTOs, workFlowWorkStartIndexMap);
    }

    private void buildWorkFlowStatusDTO(WorkFlowExecution workFlowExecution, WorkFlowDefinition workFlowDefinition, CopyOnWriteArrayList<WorkStatusResponseDTO> workStatusResponseDTOList, Map<String, Integer> workFlowWorkStartIndexMap) {
        workStatusResponseDTOList.add(WorkStatusResponseDTO.builder().name(workFlowDefinition.getName()).type(WorkType.WORKFLOW).status(WorkFlowStatus.IN_PROGRESS.equals((Object)workFlowExecution.getStatus()) ? ParodosWorkStatus.PENDING : ParodosWorkStatus.valueOf((String)workFlowExecution.getStatus().name())).workExecution(workFlowExecution).numberOfWorks(workFlowDefinition.getNumberOfWorks()).works(new ArrayList()).build());
        workFlowWorkStartIndexMap.put(workFlowDefinition.getName(), workStatusResponseDTOList.size());
        List workFlowWorkDefinitions = this.workFlowWorkRepository.findByWorkFlowDefinitionIdOrderByCreateDateAsc(workFlowDefinition.getId());
        workFlowWorkDefinitions.forEach(workFlowWorkDefinition -> {
            if (workFlowWorkDefinition.getWorkDefinitionType().equals((Object)WorkType.WORKFLOW)) {
                workStatusResponseDTOList.add(this.getWorkStatusResponseDTOFromWorkFlow(workFlowWorkDefinition, workFlowExecution));
            } else {
                workStatusResponseDTOList.add(this.getWorkStatusResponseDTOFromWorkFlowTask(workFlowWorkDefinition, workFlowExecution));
            }
        });
    }

    private void buildWorkFlowWorksStatusDTO(String workFlowName, WorkFlowExecution workFlowExecution, WorkFlowExecution mainWorkFlowExecution, CopyOnWriteArrayList<WorkStatusResponseDTO> workStatusResponseDTOList, Map<String, Integer> workFlowWorkStartIndexMap) {
        workFlowWorkStartIndexMap.put(workFlowName, workStatusResponseDTOList.size());
        List workFlowWorksDefinitions = this.workFlowWorkRepository.findByWorkFlowDefinitionIdOrderByCreateDateAsc(workFlowExecution.getWorkFlowDefinitionId());
        workFlowWorksDefinitions.forEach(workFlowWorkDefinition -> {
            if (workFlowWorkDefinition.getWorkDefinitionType().equals((Object)WorkType.WORKFLOW)) {
                workStatusResponseDTOList.add(this.getWorkStatusResponseDTOFromWorkFlow(workFlowWorkDefinition, mainWorkFlowExecution));
            } else {
                workStatusResponseDTOList.add(this.getWorkStatusResponseDTOFromWorkFlowTask(workFlowWorkDefinition, workFlowExecution));
            }
        });
    }

    private WorkStatusResponseDTO getWorkStatusResponseDTOFromWorkFlow(WorkFlowWorkDefinition workFlowWorkDefinition, WorkFlowExecution workFlowExecution) {
        WorkFlowDefinition workFlowDefinition = (WorkFlowDefinition)this.workFlowDefinitionRepository.findById((Object)workFlowWorkDefinition.getWorkDefinitionId()).get();
        WorkFlowExecution workExecution = this.workFlowRepository.findFirstByMainWorkFlowExecutionAndWorkFlowDefinitionId(workFlowExecution, workFlowWorkDefinition.getWorkDefinitionId());
        ParodosWorkStatus workStatus = workExecution == null ? ParodosWorkStatus.PENDING : ParodosWorkStatus.valueOf((String)workExecution.getStatus().name());
        return WorkStatusResponseDTO.builder().name(workFlowDefinition.getName()).type(WorkType.WORKFLOW).status(workStatus).works(new ArrayList()).workExecution(workExecution).numberOfWorks(workFlowDefinition.getNumberOfWorks()).build();
    }

    private WorkStatusResponseDTO getWorkStatusResponseDTOFromWorkFlowTask(WorkFlowWorkDefinition workFlowWorkDefinition, WorkFlowExecution workFlowExecution) {
        WorkFlowTaskDefinition workFlowTaskDefinition = (WorkFlowTaskDefinition)this.workFlowTaskDefinitionRepository.findById((Object)workFlowWorkDefinition.getWorkDefinitionId()).get();
        List workFlowTaskExecutions = this.workFlowTaskRepository.findByWorkFlowExecutionIdAndWorkFlowTaskDefinitionId(workFlowExecution.getId(), workFlowWorkDefinition.getWorkDefinitionId());
        Optional<WorkFlowTaskExecution> workFlowTaskExecutionOptional = workFlowTaskExecutions.stream().max(Comparator.comparing(WorkFlowTaskExecution::getStartDate));
        ParodosWorkStatus workStatus = ParodosWorkStatus.PENDING;
        if (workFlowTaskExecutionOptional.isPresent()) {
            workStatus = ParodosWorkStatus.valueOf((String)workFlowTaskExecutionOptional.get().getStatus().name());
            if (workFlowTaskDefinition.getWorkFlowCheckerMappingDefinition() != null) {
                workStatus = Optional.ofNullable(this.workFlowRepository.findFirstByMainWorkFlowExecutionAndWorkFlowDefinitionId(Optional.ofNullable(workFlowExecution.getMainWorkFlowExecution()).orElse(workFlowExecution), workFlowTaskDefinition.getWorkFlowCheckerMappingDefinition().getCheckWorkFlow().getId())).map(WorkFlowExecution::getStatus).map(checkerStatus -> WorkFlowStatus.FAILED.equals(checkerStatus) ? ParodosWorkStatus.IN_PROGRESS : ParodosWorkStatus.valueOf((String)checkerStatus.name())).orElse(ParodosWorkStatus.COMPLETED.equals((Object)workStatus) ? ParodosWorkStatus.IN_PROGRESS : workStatus);
            }
        }
        return WorkStatusResponseDTO.builder().name(workFlowTaskDefinition.getName()).type(WorkType.TASK).status(workStatus).build();
    }

    private List<WorkStatusResponseDTO> nestWorkFlowWorksStatusDTO(CopyOnWriteArrayList<WorkStatusResponseDTO> workStatusResponseDTOs, Map<String, Integer> workFlowWorksStartIndexMap) {
        for (int j = workStatusResponseDTOs.size() - 1; j >= 0; --j) {
            if (!workStatusResponseDTOs.get(j).getType().equals((Object)WorkType.WORKFLOW) || workStatusResponseDTOs.get(j).getWorkExecution() == null) continue;
            ArrayList<WorkStatusResponseDTO> tmpList = new ArrayList<WorkStatusResponseDTO>();
            for (int k = workFlowWorksStartIndexMap.get(workStatusResponseDTOs.get(j).getName()).intValue(); k < workFlowWorksStartIndexMap.get(workStatusResponseDTOs.get(j).getName()) + workStatusResponseDTOs.get(j).getNumberOfWorks(); ++k) {
                tmpList.add(workStatusResponseDTOs.get(k));
            }
            workStatusResponseDTOs.get(j).setWorks(tmpList);
        }
        return workStatusResponseDTOs.get(0).getWorks();
    }
}

