/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.service;

import com.redhat.parodos.project.dto.ProjectResponseDTO;
import com.redhat.parodos.project.service.ProjectService;
import com.redhat.parodos.security.SecurityUtils;
import com.redhat.parodos.workflow.WorkFlowDelegate;
import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.definition.entity.WorkFlowDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowTaskDefinition;
import com.redhat.parodos.workflow.definition.repository.WorkFlowDefinitionRepository;
import com.redhat.parodos.workflow.definition.repository.WorkFlowTaskDefinitionRepository;
import com.redhat.parodos.workflow.definition.repository.WorkFlowWorkRepository;
import com.redhat.parodos.workflow.definition.service.WorkFlowDefinitionService;
import com.redhat.parodos.workflow.enums.WorkFlowStatus;
import com.redhat.parodos.workflow.enums.WorkFlowType;
import com.redhat.parodos.workflow.exceptions.WorkflowPersistenceFailedException;
import com.redhat.parodos.workflow.execution.dto.WorkFlowContextResponseDTO;
import com.redhat.parodos.workflow.execution.dto.WorkFlowOptionsResponseDTO;
import com.redhat.parodos.workflow.execution.dto.WorkFlowRequestDTO;
import com.redhat.parodos.workflow.execution.dto.WorkFlowResponseDTO;
import com.redhat.parodos.workflow.execution.dto.WorkFlowStatusResponseDTO;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import com.redhat.parodos.workflow.execution.entity.WorkFlowTaskExecution;
import com.redhat.parodos.workflow.execution.repository.WorkFlowRepository;
import com.redhat.parodos.workflow.execution.repository.WorkFlowTaskRepository;
import com.redhat.parodos.workflow.execution.service.WorkFlowService;
import com.redhat.parodos.workflow.execution.service.WorkFlowServiceDelegate;
import com.redhat.parodos.workflow.option.WorkFlowOption;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskStatus;
import com.redhat.parodos.workflow.utils.WorkContextUtils;
import com.redhat.parodos.workflows.engine.WorkFlowEngineBuilder;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WorkFlowServiceImpl
implements WorkFlowService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowServiceImpl.class);
    private final ProjectService projectService;
    private final WorkFlowDelegate workFlowDelegate;
    private final WorkFlowServiceDelegate workFlowServiceDelegate;
    private final WorkFlowDefinitionRepository workFlowDefinitionRepository;
    private final WorkFlowTaskDefinitionRepository workFlowTaskDefinitionRepository;
    private final WorkFlowRepository workFlowRepository;
    private final WorkFlowTaskRepository workFlowTaskRepository;
    private final WorkFlowWorkRepository workFlowWorkRepository;
    private final WorkFlowDefinitionService workFlowDefinitionService;
    private final MeterRegistry metricRegistry;

    public WorkFlowServiceImpl(WorkFlowDelegate workFlowDelegate, WorkFlowServiceDelegate workFlowServiceDelegate, WorkFlowDefinitionRepository workFlowDefinitionRepository, WorkFlowTaskDefinitionRepository workFlowTaskDefinitionRepository, WorkFlowRepository workFlowRepository, WorkFlowTaskRepository workFlowTaskRepository, WorkFlowWorkRepository workFlowWorkRepository, WorkFlowDefinitionService workFlowDefinitionService, MeterRegistry metricRegistry, ProjectService projectService, ModelMapper modelMapper) {
        this.workFlowDelegate = workFlowDelegate;
        this.workFlowServiceDelegate = workFlowServiceDelegate;
        this.workFlowDefinitionRepository = workFlowDefinitionRepository;
        this.workFlowTaskDefinitionRepository = workFlowTaskDefinitionRepository;
        this.workFlowRepository = workFlowRepository;
        this.workFlowTaskRepository = workFlowTaskRepository;
        this.workFlowWorkRepository = workFlowWorkRepository;
        this.workFlowDefinitionService = workFlowDefinitionService;
        this.metricRegistry = metricRegistry;
        this.projectService = projectService;
    }

    private void statusCounterWithStatus(WorkFlowStatus status) {
        if (status == null) {
            return;
        }
        Counter.builder((String)"workflow.executions").tag("status", status.toString()).description("Workflow executions phases by status update").register(this.metricRegistry).increment();
    }

    public WorkReport execute(WorkFlowRequestDTO workFlowRequestDTO) {
        WorkFlow workFlow;
        String workflowName = workFlowRequestDTO.getWorkFlowName();
        String validationFailedMsg = this.validateWorkflow(workflowName, workFlow = this.workFlowDelegate.getWorkFlowExecutionByName(workflowName));
        if (validationFailedMsg != null) {
            return new DefaultWorkReport(WorkStatus.FAILED, new WorkContext(), new Throwable(validationFailedMsg));
        }
        WorkContext workContext = this.workFlowDelegate.initWorkFlowContext(workFlowRequestDTO, this.workFlowDefinitionService.getWorkFlowDefinitionByName(workflowName));
        UUID projectId = workFlowRequestDTO.getProjectId();
        return this.execute(projectId, workflowName, workContext, null);
    }

    public WorkReport execute(UUID projectId, String workflowName, WorkContext workContext, UUID executionId) {
        WorkFlow workFlow = this.workFlowDelegate.getWorkFlowExecutionByName(workflowName);
        log.info("execute workFlow '{}': {}", (Object)workflowName, (Object)workFlow);
        WorkContextUtils.setProjectId((WorkContext)workContext, (UUID)projectId);
        if (executionId != null) {
            WorkContextDelegate.write((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.ID, (Object)executionId.toString());
        }
        WorkContextDelegate.write((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_DEFINITION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.NAME, (Object)workflowName);
        return WorkFlowEngineBuilder.aNewWorkFlowEngine().build().run(workFlow, workContext);
    }

    public WorkFlowExecution getWorkFlowById(UUID workFlowExecutionId) {
        return this.workFlowRepository.findById((Object)workFlowExecutionId).orElse(null);
    }

    public WorkFlowExecution saveWorkFlow(UUID projectId, UUID workFlowDefinitionId, WorkFlowStatus workFlowStatus, WorkFlowExecution mainWorkFlowExecution, String arguments) {
        try {
            this.statusCounterWithStatus(workFlowStatus);
            return (WorkFlowExecution)this.workFlowRepository.save((Object)WorkFlowExecution.builder().workFlowDefinitionId(workFlowDefinitionId).projectId(projectId).status(workFlowStatus).startDate(new Date()).arguments(arguments).mainWorkFlowExecution(mainWorkFlowExecution).build());
        }
        catch (IllegalArgumentException | DataAccessException e) {
            log.error("failing persist workflow execution for: {} in main workflow execution: {}. error Message: {}", new Object[]{workFlowDefinitionId, mainWorkFlowExecution.getId(), e.getMessage()});
            throw new WorkflowPersistenceFailedException(e.getMessage());
        }
    }

    public synchronized WorkFlowExecution updateWorkFlow(WorkFlowExecution workFlowExecution) {
        this.statusCounterWithStatus(workFlowExecution.getStatus());
        return (WorkFlowExecution)this.workFlowRepository.save((Object)workFlowExecution);
    }

    public List<WorkFlowResponseDTO> getWorkFlowsByProjectId(UUID projectId) {
        ProjectResponseDTO project = this.projectService.getProjectByIdAndUsername(projectId, SecurityUtils.getUsername());
        return this.workFlowRepository.findAllByProjectId(project.getId()).stream().filter(workFlowExecution -> workFlowExecution.getMainWorkFlowExecution() == null).map(arg_0 -> this.buildWorkflowResponseDTO(arg_0)).toList();
    }

    public List<WorkFlowResponseDTO> getWorkFlows() {
        List projects = this.projectService.findProjectsByUserName(SecurityUtils.getUsername());
        return projects.stream().flatMap(project -> this.workFlowRepository.findAllByProjectId(project.getId()).stream().filter(workFlowExecution -> workFlowExecution.getMainWorkFlowExecution() == null).map(arg_0 -> this.buildWorkflowResponseDTO(arg_0))).toList();
    }

    public WorkFlowStatusResponseDTO getWorkFlowStatus(UUID workFlowExecutionId) {
        WorkFlowExecution workFlowExecution = (WorkFlowExecution)this.workFlowRepository.findById((Object)workFlowExecutionId).orElseThrow(() -> {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("workflow execution id: %s not found!", workFlowExecutionId));
        });
        WorkFlowDefinition workFlowDefinition = (WorkFlowDefinition)this.workFlowDefinitionRepository.findById((Object)workFlowExecution.getWorkFlowDefinitionId()).orElseThrow(() -> {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("workflow definition id: %s not found!", workFlowExecution.getId()));
        });
        if (workFlowExecution.getMainWorkFlowExecution() != null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, String.format("workflow id: %s from workflow name: %s is an inner workflow!", workFlowExecution.getId(), workFlowDefinition.getName()));
        }
        List workFlowWorksStatusResponseDTOs = this.workFlowServiceDelegate.getWorkFlowAndWorksStatus(workFlowExecution, workFlowDefinition);
        return WorkFlowStatusResponseDTO.builder().workFlowExecutionId(workFlowExecution.getId()).workFlowName(workFlowDefinition.getName()).status(workFlowExecution.getStatus().name()).works(workFlowWorksStatusResponseDTOs).build();
    }

    public WorkFlowContextResponseDTO getWorkflowParameters(UUID workFlowExecutionId, List<WorkContextDelegate.Resource> params) {
        WorkFlowExecution workFlowExecution = (WorkFlowExecution)this.workFlowRepository.findById((Object)workFlowExecutionId).orElseThrow(() -> {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("workflow execution id: %s not found!", workFlowExecutionId));
        });
        Map options = Map.of();
        if (params.contains(WorkContextDelegate.Resource.WORKFLOW_OPTIONS)) {
            options = Optional.ofNullable((Map)WorkContextDelegate.read((WorkContext)workFlowExecution.getWorkFlowExecutionContext().getWorkContext(), (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.WORKFLOW_OPTIONS)).orElse(Map.of());
        }
        return WorkFlowContextResponseDTO.builder().workFlowExecutionId(workFlowExecution.getId()).workFlowOptions(WorkFlowOptionsResponseDTO.builder().currentVersion((WorkFlowOption)options.get("currentVersion")).continuationOptions(WorkFlowServiceImpl.getFlowOptions(options, (String)"continuationOptions")).migrationOptions(WorkFlowServiceImpl.getFlowOptions(options, (String)"migrationOptions")).otherOptions(WorkFlowServiceImpl.getFlowOptions(options, (String)"otherOptions")).upgradeOptions(WorkFlowServiceImpl.getFlowOptions(options, (String)"upgradeOptions")).newOptions(WorkFlowServiceImpl.getFlowOptions(options, (String)"newOptions")).build()).build();
    }

    @Nullable
    private static List<WorkFlowOption> getFlowOptions(Map options, String key) {
        return options.containsKey(key) ? (List)options.get(key) : null;
    }

    public WorkFlowTaskExecution getWorkFlowTask(UUID workFlowExecutionId, UUID workFlowTaskDefinitionId) {
        List workFlowTaskExecutionList = this.workFlowTaskRepository.findByWorkFlowExecutionIdAndWorkFlowTaskDefinitionId(workFlowExecutionId, workFlowTaskDefinitionId);
        return workFlowTaskExecutionList == null || workFlowTaskExecutionList.isEmpty() ? null : (WorkFlowTaskExecution)workFlowTaskExecutionList.stream().findFirst().get();
    }

    public WorkFlowTaskExecution saveWorkFlowTask(String arguments, UUID workFlowTaskDefinitionId, UUID workFlowExecutionId, WorkFlowTaskStatus workFlowTaskStatus) {
        try {
            return (WorkFlowTaskExecution)this.workFlowTaskRepository.save((Object)WorkFlowTaskExecution.builder().workFlowExecutionId(workFlowExecutionId).workFlowTaskDefinitionId(workFlowTaskDefinitionId).arguments(arguments).status(workFlowTaskStatus).startDate(new Date()).build());
        }
        catch (IllegalArgumentException | DataAccessException e) {
            log.error("failing persist task execution for: {} in main workflow execution: {}. error Message: {}", new Object[]{workFlowTaskDefinitionId, workFlowTaskDefinitionId, e.getMessage()});
            throw new WorkflowPersistenceFailedException(e.getMessage());
        }
    }

    public WorkFlowTaskExecution updateWorkFlowTask(WorkFlowTaskExecution workFlowTaskExecution) {
        try {
            return (WorkFlowTaskExecution)this.workFlowTaskRepository.save((Object)workFlowTaskExecution);
        }
        catch (IllegalArgumentException | DataAccessException e) {
            log.error("failed updating task execution for: {} in execution: {}. error Message: {}", new Object[]{workFlowTaskExecution.getWorkFlowTaskDefinitionId(), workFlowTaskExecution.getId(), e.getMessage()});
            throw new WorkflowPersistenceFailedException(e.getMessage());
        }
    }

    public void updateWorkFlowCheckerTaskStatus(UUID workFlowExecutionId, String workFlowTaskName, WorkFlowTaskStatus workFlowTaskStatus) {
        WorkFlowExecution mainWorkFlowExecution = (WorkFlowExecution)this.workFlowRepository.findById((Object)workFlowExecutionId).orElseThrow(() -> {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("workflow execution id: %s not found!", workFlowExecutionId));
        });
        WorkFlowTaskDefinition workFlowTaskDefinition = this.workFlowTaskDefinitionRepository.findFirstByNameAndWorkFlowDefinitionType(workFlowTaskName, WorkFlowType.CHECKER);
        if (Objects.isNull(workFlowTaskDefinition)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("workflow checker task name: %s not found!", workFlowTaskName));
        }
        List workFlowExecutions = this.workFlowRepository.findByMainWorkFlowExecution(mainWorkFlowExecution);
        WorkFlowExecution workFlowCheckerExecution = workFlowExecutions.stream().filter(workFlowExecution -> workFlowExecution.getWorkFlowDefinitionId().equals(workFlowTaskDefinition.getWorkFlowDefinition().getId())).max(Comparator.comparing(WorkFlowExecution::getStartDate)).orElseThrow(() -> {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, String.format("workflow checker associated to task: %s has not started!", workFlowTaskName));
        });
        WorkFlowTaskExecution workFlowTaskExecution = (WorkFlowTaskExecution)this.workFlowTaskRepository.findByWorkFlowExecutionIdAndWorkFlowTaskDefinitionId(workFlowCheckerExecution.getId(), workFlowTaskDefinition.getId()).stream().findFirst().orElseThrow(() -> {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, String.format("workflow checker task name: %s has not been executed!", workFlowTaskName));
        });
        workFlowTaskExecution.setStatus(workFlowTaskStatus);
        this.workFlowTaskRepository.save((Object)workFlowTaskExecution);
    }

    public List<WorkFlowExecution> findRunningChecker(WorkFlowExecution mainWorkFlow) {
        return this.workFlowRepository.findRunningCheckersById(mainWorkFlow.getId());
    }

    private String validateWorkflow(String workflowName, WorkFlow workFlow) {
        if (workFlow == null) {
            log.error("workflow '{}' is not found!", (Object)workflowName);
            return String.format("workflow '%s' cannot be found!", workflowName);
        }
        WorkFlowDefinition workFlowDefinition = this.workFlowDefinitionRepository.findFirstByName(workflowName);
        if (workFlowDefinition == null) {
            return String.format("workflow '%s' is not registered!", workflowName);
        }
        if (this.workFlowWorkRepository.findFirstByWorkDefinitionId(workFlowDefinition.getId()) != null) {
            log.error("workflow '{}' is not main workflow!", (Object)workflowName);
            return String.format("workflow '%s' is not main workflow!", workflowName);
        }
        return null;
    }

    @PreDestroy
    public void gracefulShutdown() {
        log.info(">> Shutting down the workflow service");
    }

    private WorkFlowResponseDTO buildWorkflowResponseDTO(WorkFlowExecution workflowExecution) {
        return WorkFlowResponseDTO.builder().workFlowExecutionId(workflowExecution.getId()).projectId(workflowExecution.getProjectId()).workFlowName(this.workFlowDefinitionService.getWorkFlowDefinitionById(workflowExecution.getWorkFlowDefinitionId()).getName()).workStatus(WorkStatus.valueOf((String)workflowExecution.getStatus().name())).startDate((String)Optional.ofNullable(workflowExecution.getStartDate()).map(Date::toString).orElse(null)).endDate((String)Optional.ofNullable(workflowExecution.getEndDate()).map(Date::toString).orElse(null)).createUser(SecurityUtils.getUsername()).build();
    }
}

