/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto;

import dev.paseto.jpaseto.FooterClaims;
import dev.paseto.jpaseto.KeyResolver;
import dev.paseto.jpaseto.PasetoSignatureException;
import dev.paseto.jpaseto.Purpose;
import dev.paseto.jpaseto.UnsupportedPasetoException;
import dev.paseto.jpaseto.Version;
import dev.paseto.jpaseto.lang.Assert;
import dev.paseto.jpaseto.lang.Keys;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.SecretKey;

public abstract class KeyResolverAdapter
implements KeyResolver {
    @Override
    public PublicKey resolvePublicKey(Version version, Purpose purpose, FooterClaims footer) {
        Assert.isTrue(Purpose.PUBLIC == purpose, "Token purpose MUST be 'public' to resolve a public key, found: " + (Object)((Object)purpose));
        if (Version.V1 == version) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePublic(new X509EncodedKeySpec(this.resolvePublicKeyBytes(version, purpose, footer)));
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new PasetoSignatureException("Failed to load RSA key.", e);
            }
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("Ed25519");
            return keyFactory.generatePublic(new X509EncodedKeySpec(this.resolvePublicKeyBytes(version, purpose, footer)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new PasetoSignatureException("Failed to load Ed25519 key.", e);
        }
    }

    @Override
    public SecretKey resolveSharedKey(Version version, Purpose purpose, FooterClaims footer) {
        return Keys.secretKey(this.resolveSharedKeyBytes(version, purpose, footer));
    }

    protected byte[] resolvePublicKeyBytes(Version version, Purpose purpose, FooterClaims footer) {
        throw new UnsupportedPasetoException("The specified KeyResolver implementation does not support public key resolution.  Consider overriding either the resolvePublicKeyBytes(Paseto) method.");
    }

    protected byte[] resolveSharedKeyBytes(Version version, Purpose purpose, FooterClaims footer) {
        throw new UnsupportedPasetoException("The specified KeyResolver implementation does not support shared secret key resolution.  Consider overriding either the resolveSharedKeyBytes(Version, Purpose, FooterClaims) method.");
    }
}

