/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto;

import dev.paseto.jpaseto.KeyResolver;
import dev.paseto.jpaseto.PasetoParser;
import dev.paseto.jpaseto.io.Deserializer;
import dev.paseto.jpaseto.lang.DescribedPredicate;
import dev.paseto.jpaseto.lang.Keys;
import java.security.PublicKey;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.function.Predicate;
import javax.crypto.SecretKey;

public interface PasetoParserBuilder {
    public PasetoParserBuilder setKeyResolver(KeyResolver var1);

    public PasetoParserBuilder setPublicKey(PublicKey var1);

    default public PasetoParserBuilder setSharedSecret(byte[] sharedSecret) {
        this.setSharedSecret(Keys.secretKey(sharedSecret));
        return this;
    }

    public PasetoParserBuilder setSharedSecret(SecretKey var1);

    public PasetoParserBuilder setDeserializer(Deserializer<Map<String, Object>> var1);

    public PasetoParser build();

    default public PasetoParserBuilder requireIssuer(String iss) {
        return this.require("iss", DescribedPredicate.equalTo(iss));
    }

    default public PasetoParserBuilder requireSubject(String sub) {
        return this.require("sub", DescribedPredicate.equalTo(sub));
    }

    default public PasetoParserBuilder requireAudience(String aud) {
        return this.require("aud", DescribedPredicate.equalTo(aud));
    }

    default public PasetoParserBuilder requireExpiration(Instant exp) {
        return this.require("exp", DescribedPredicate.equalTo(exp));
    }

    default public PasetoParserBuilder requireNotBefore(Instant nbf) {
        return this.require("nbf", DescribedPredicate.equalTo(nbf));
    }

    default public PasetoParserBuilder requireIssuedAt(Instant iat) {
        return this.require("iat", DescribedPredicate.equalTo(iat));
    }

    default public PasetoParserBuilder requireTokenId(String jti) {
        return this.require("jti", DescribedPredicate.equalTo(jti));
    }

    default public PasetoParserBuilder requireKeyId(String kid) {
        return this.requireFooter("kid", DescribedPredicate.equalTo(kid));
    }

    default public PasetoParserBuilder require(String claimName, Object value) {
        return this.require(claimName, DescribedPredicate.equalTo(value));
    }

    public PasetoParserBuilder require(String var1, Predicate<Object> var2);

    public PasetoParserBuilder requireFooter(String var1, Predicate<Object> var2);

    public PasetoParserBuilder setClock(Clock var1);

    public PasetoParserBuilder setAllowedClockSkew(Duration var1);
}

