/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.lang;

import dev.paseto.jpaseto.PasetoKeyException;
import dev.paseto.jpaseto.Version;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class Keys {
    private Keys() {
    }

    public static SecretKey secretKey(byte[] bytes) {
        return new SecretKeySpec(bytes, "none");
    }

    public static SecretKey secretKey() {
        byte[] keyBytes = new byte[32];
        try {
            SecureRandom.getInstanceStrong().nextBytes(keyBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("JVM does not provide a strong secure random number generator", e);
        }
        return new SecretKeySpec(keyBytes, "none");
    }

    public static KeyPair keyPairFor(Version version) {
        if (Version.V1 == version) {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                keyPairGenerator.initialize(2048);
                return keyPairGenerator.generateKeyPair();
            }
            catch (NoSuchAlgorithmException e) {
                throw new PasetoKeyException("Failed to generate RSA key pair", e);
            }
        }
        if (Version.V2 == version) {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("Ed25519");
                return keyPairGenerator.generateKeyPair();
            }
            catch (NoSuchAlgorithmException e) {
                throw new PasetoKeyException("Failed to generate Ed25519 key pair", e);
            }
        }
        throw new PasetoKeyException("Failed to generate keypair, version is not supported: " + (Object)((Object)version));
    }
}

