/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.lang;

import dev.paseto.jpaseto.lang.Assert;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;

public final class DateFormats {
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendOffsetId().toFormatter().withZone(ZoneOffset.UTC);

    private DateFormats() {
    }

    public static String formatIso8601(Instant instant) {
        return ISO_OFFSET_DATE_TIME.format(instant);
    }

    public static Instant parseIso8601Date(String s) throws DateTimeException {
        Assert.notNull(s, "String argument cannot be null.");
        return Instant.from(ISO_OFFSET_DATE_TIME.parse(s));
    }
}

