/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.lang;

import dev.paseto.jpaseto.lang.Assert;
import dev.paseto.jpaseto.lang.UnavailableImplementationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public final class Services {
    private Services() {
    }

    public static <T> List<T> loadAll(Class<T> spi) {
        Assert.notNull(spi, "Parameter 'spi' must not be null.");
        ServiceLoader<T> serviceLoader = ServiceLoader.load(spi);
        ArrayList<T> implementations = new ArrayList<T>();
        for (T implementation : serviceLoader) {
            implementations.add(implementation);
        }
        if (implementations.isEmpty()) {
            throw new UnavailableImplementationException(spi);
        }
        return Collections.unmodifiableList(implementations);
    }

    public static <T> T loadFirst(Class<T> spi) {
        return Services.loadFirst(spi, null);
    }

    public static <T> T loadFirst(Class<T> spi, T defaultValue) {
        Assert.notNull(spi, "Parameter 'spi' must not be null.");
        ServiceLoader<T> serviceLoader = ServiceLoader.load(spi);
        if (serviceLoader.iterator().hasNext()) {
            return serviceLoader.iterator().next();
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new UnavailableImplementationException(spi);
    }
}

